/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.authentication.standard;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.NamedParameterSpec;
import java.sql.SQLException;
import java.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ParsecPasswordPluginTool {
    public static byte[] process(final byte[] rawPrivateKey) throws SQLException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("Ed25519");
        keyPairGenerator.initialize(NamedParameterSpec.ED25519, new SecureRandom(){

            @Override
            public void nextBytes(byte[] bytes) {
                System.arraycopy(rawPrivateKey, 0, bytes, 0, rawPrivateKey.length);
            }
        });
        byte[] spki = keyPairGenerator.generateKeyPair().getPublic().getEncoded();
        byte[] rawPublicKey = Arrays.copyOfRange(spki, spki.length - 32, spki.length);
        return rawPublicKey;
    }
}

