/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.insert;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.SingularAttribute;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.criteria.JpaConflictUpdateAction;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.internal.TypecheckUtil;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;

public class SqmConflictUpdateAction<T>
implements SqmNode,
JpaConflictUpdateAction<T> {
    private final SqmInsertStatement<T> insertStatement;
    private final SqmSetClause setClause;
    private @Nullable SqmWhereClause whereClause;

    public SqmConflictUpdateAction(SqmInsertStatement<T> insertStatement) {
        this.insertStatement = insertStatement;
        this.setClause = new SqmSetClause();
    }

    private SqmConflictUpdateAction(SqmInsertStatement<T> insertStatement, SqmSetClause setClause, @Nullable SqmWhereClause whereClause) {
        this.insertStatement = insertStatement;
        this.setClause = setClause;
        this.whereClause = whereClause;
    }

    @Override
    public <Y, X extends Y> SqmConflictUpdateAction<T> set(SingularAttribute<? super T, Y> attribute, X value) {
        this.applyAssignment((SqmPath<Y>)this.getTarget().get((SingularAttribute)attribute), (SqmExpression)this.nodeBuilder().value(value));
        return this;
    }

    @Override
    public <Y> SqmConflictUpdateAction<T> set(SingularAttribute<? super T, Y> attribute, Expression<? extends Y> value) {
        this.applyAssignment((SqmPath<Y>)this.getTarget().get((SingularAttribute)attribute), (SqmExpression)value);
        return this;
    }

    @Override
    public <Y, X extends Y> SqmConflictUpdateAction<T> set(Path<Y> attribute, X value) {
        this.applyAssignment((SqmPath)attribute, (SqmExpression)this.nodeBuilder().value(value));
        return this;
    }

    @Override
    public <Y> SqmConflictUpdateAction<T> set(Path<Y> attribute, Expression<? extends Y> value) {
        this.applyAssignment((SqmPath)attribute, (SqmExpression)value);
        return this;
    }

    @Override
    public SqmConflictUpdateAction<T> set(String attributeName, Object value) {
        JpaPath sqmPath = this.getTarget().get(attributeName);
        SqmExpression expression = value instanceof SqmExpression ? (SqmExpression)value : (SqmExpression)this.nodeBuilder().value(value);
        TypecheckUtil.assertAssignable(null, sqmPath, expression, this.nodeBuilder());
        this.applyAssignment((SqmPath)sqmPath, expression);
        return this;
    }

    public void addAssignment(SqmAssignment<?> assignment) {
        this.setClause.addAssignment(assignment);
    }

    private <Y> void applyAssignment(SqmPath<Y> targetPath, SqmExpression<? extends Y> value) {
        this.setClause.addAssignment(new SqmAssignment<Y>(targetPath, value));
    }

    @Override
    public SqmConflictUpdateAction<T> where(Expression<Boolean> restriction) {
        this.initAndGetWhereClause().setPredicate((SqmPredicate)restriction);
        return this;
    }

    @Override
    public SqmConflictUpdateAction<T> where(Predicate ... restrictions) {
        SqmWhereClause whereClause = this.initAndGetWhereClause();
        whereClause.setPredicate(null);
        for (Predicate restriction : restrictions) {
            whereClause.applyPredicate((SqmPredicate)restriction);
        }
        return this;
    }

    @Override
    public SqmPredicate getRestriction() {
        return this.whereClause == null ? null : this.whereClause.getPredicate();
    }

    protected SqmWhereClause initAndGetWhereClause() {
        if (this.whereClause == null) {
            this.whereClause = new SqmWhereClause(this.nodeBuilder());
        }
        return this.whereClause;
    }

    @Override
    public NodeBuilder nodeBuilder() {
        return this.insertStatement.nodeBuilder();
    }

    @Override
    public SqmConflictUpdateAction<T> copy(SqmCopyContext context) {
        SqmConflictUpdateAction existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        return context.registerCopy(this, new SqmConflictUpdateAction<T>(this.insertStatement.copy(context), this.setClause.copy(context), this.whereClause == null ? null : this.whereClause.copy(context)));
    }

    public SqmSetClause getSetClause() {
        return this.setClause;
    }

    public SqmWhereClause getWhereClause() {
        return this.whereClause;
    }

    private SqmRoot<T> getTarget() {
        return this.insertStatement.getTarget();
    }

    public void appendHqlString(StringBuilder sb, SqmRenderContext context) {
        sb.append(" do update");
        this.setClause.appendHqlString(sb, context);
        if (this.whereClause != null && this.whereClause.getPredicate() != null) {
            sb.append(" where ");
            this.whereClause.getPredicate().appendHqlString(sb, context);
        }
    }
}

