/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls;

import io.quarkus.tls.TlsConfigurationRegistry;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import java.security.KeyStore;
import java.util.Optional;
import javax.net.ssl.SSLContext;

public interface TlsConfiguration {
    public static Optional<TlsConfiguration> from(TlsConfigurationRegistry registry, Optional<String> name) {
        if (name.isPresent()) {
            Optional<TlsConfiguration> maybeConfiguration = registry.get(name.get());
            if (maybeConfiguration.isEmpty()) {
                throw new IllegalStateException("Unable to find the TLS configuration for name " + name.get() + ".");
            }
            return maybeConfiguration;
        }
        return Optional.empty();
    }

    public KeyStore getKeyStore();

    public KeyCertOptions getKeyStoreOptions();

    public KeyStore getTrustStore();

    public TrustOptions getTrustStoreOptions();

    public SSLOptions getSSLOptions();

    public SSLContext createSSLContext() throws Exception;

    public boolean isTrustAll();

    public Optional<String> getHostnameVerificationAlgorithm();

    public boolean usesSni();

    public boolean reload();

    default public String getName() {
        return "unset";
    }
}

