/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.aggregate;

import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class H2AggregateSupport
extends AggregateSupportImpl {
    private static final AggregateSupport INSTANCE = new H2AggregateSupport();

    public static @Nullable AggregateSupport valueOf(Dialect dialect) {
        return dialect.getVersion().isSameOrAfter(2, 2, 220) ? INSTANCE : AggregateSupportImpl.INSTANCE;
    }

    @Override
    public String aggregateComponentCustomReadExpression(String template, String placeholder, String aggregateParentReadExpression, String columnExpression, int aggregateColumnTypeCode, SqlTypedMapping column, TypeConfiguration typeConfiguration) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case 3001: 
                    case 3018: {
                        return template.replace(placeholder, "(" + aggregateParentReadExpression + ").\"" + columnExpression + "\"");
                    }
                    case -3: 
                    case -2: 
                    case 4003: {
                        return template.replace(placeholder, H2AggregateSupport.hexDecodeExpression(H2AggregateSupport.queryExpression("(" + aggregateParentReadExpression + ").\"" + columnExpression + "\""), column.getColumnDefinition()));
                    }
                    case 2003: {
                        BasicPluralType pluralType = (BasicPluralType)column.getJdbcMapping();
                        String elementTypeName = H2AggregateSupport.getElementTypeName(column.getColumnDefinition());
                        switch (pluralType.getElementType().getJdbcType().getDefaultSqlTypeCode()) {
                            case -3: 
                            case -2: 
                            case 4003: {
                                return template.replace(placeholder, "(select array_agg(" + H2AggregateSupport.hexDecodeExpression(H2AggregateSupport.queryExpression("(" + aggregateParentReadExpression + ").\"" + columnExpression + "\"[i.x]"), elementTypeName) + ") from system_range(1,10000) i where i.x<=coalesce(array_length((" + aggregateParentReadExpression + ").\"" + columnExpression + "\"),0))");
                            }
                        }
                        return template.replace(placeholder, "(select array_agg(" + H2AggregateSupport.valueExpression("(" + aggregateParentReadExpression + ").\"" + columnExpression + "\"[i.x]", elementTypeName) + ") from system_range(1,10000) i where i.x<=coalesce(array_length((" + aggregateParentReadExpression + ").\"" + columnExpression + "\"),0))");
                    }
                }
                return template.replace(placeholder, H2AggregateSupport.columnExpression(aggregateParentReadExpression, columnExpression, column.getColumnDefinition()));
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    private static String getElementTypeName(String arrayTypeName) {
        String elementTypeName = arrayTypeName.substring(0, arrayTypeName.lastIndexOf(" array"));
        return elementTypeName.equals("clob") ? "varchar" : elementTypeName;
    }

    private static String columnExpression(String aggregateParentReadExpression, String columnExpression, String columnType) {
        return H2AggregateSupport.valueExpression("(" + aggregateParentReadExpression + ").\"" + columnExpression + "\"", columnType);
    }

    private static String hexDecodeExpression(String valueExpression, String columnType) {
        return "cast(hextoraw(regexp_replace(" + valueExpression + ",'([0-9a-f][0-9a-f])','00$1')) as " + columnType + ")";
    }

    private static String valueExpression(String valueExpression, String columnType) {
        return "cast(" + H2AggregateSupport.queryExpression(valueExpression) + " as " + columnType + ")";
    }

    private static String queryExpression(String valueExpression) {
        return "stringdecode(regexp_replace(nullif(" + valueExpression + ",JSON'null'),'^\"(.*)\"$','$1'))";
    }

    private static String jsonCustomWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping) {
        int sqlTypeCode = jdbcMapping.getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode) {
            case -3: 
            case -2: 
            case 4003: {
                return "rawtohex(" + customWriteExpression + ")";
            }
            case 2003: {
                BasicPluralType pluralType = (BasicPluralType)jdbcMapping;
                switch (pluralType.getElementType().getJdbcType().getDefaultSqlTypeCode()) {
                    case -3: 
                    case -2: 
                    case 4003: {
                        return "(select array_agg(rawtohex(t.c1)) from unnest(" + customWriteExpression + ") t)";
                    }
                }
                return customWriteExpression;
            }
        }
        return customWriteExpression;
    }

    @Override
    public String aggregateComponentAssignmentExpression(String aggregateParentAssignmentExpression, String columnExpression, int aggregateColumnTypeCode, Column column) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                return aggregateParentAssignmentExpression;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    @Override
    public boolean requiresAggregateCustomWriteExpressionRenderer(int aggregateSqlTypeCode) {
        switch (aggregateSqlTypeCode) {
            case 3001: {
                return true;
            }
        }
        return false;
    }

    @Override
    public AggregateSupport.WriteExpressionRenderer aggregateCustomWriteExpressionRenderer(SelectableMapping aggregateColumn, SelectableMapping[] columnsToUpdate, TypeConfiguration typeConfiguration) {
        int aggregateSqlTypeCode = aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        switch (aggregateSqlTypeCode) {
            case 3001: {
                return this.jsonAggregateColumnWriter(aggregateColumn, columnsToUpdate);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateSqlTypeCode);
    }

    private AggregateSupport.WriteExpressionRenderer jsonAggregateColumnWriter(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
        return new RootJsonWriteExpression(aggregateColumn, columns);
    }

    private static class RootJsonWriteExpression
    extends AggregateJsonWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final String path;

        RootJsonWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(aggregateColumn, columns);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            this.append(sqlAppender, "(" + (String)basePath + ")", translator, aggregateColumnWriteExpression);
        }
    }

    private static class PassThroughExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;

        PassThroughExpression(SelectableMapping selectableMapping) {
            this.selectableMapping = selectableMapping;
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append('\'');
            sb.append(this.selectableMapping.getSelectableName());
            sb.append("':");
            sb.append(path);
        }
    }

    private static class BasicJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicJsonWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append('\'');
            sb.append(this.selectableMapping.getSelectableName());
            sb.append("':");
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(this.customWriteExpressionEnd);
        }
    }

    private static class AggregateJsonWriteExpression
    implements JsonWriteExpression {
        private final LinkedHashMap<String, JsonWriteExpression> subExpressions = new LinkedHashMap();

        private AggregateJsonWriteExpression() {
        }

        protected void initializeSubExpressions(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateJsonWriteExpression currentAggregate = this;
                for (int i = 1; i < parts.length - 1; ++i) {
                    currentAggregate = (AggregateJsonWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateJsonWriteExpression());
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicJsonWriteExpression(column, H2AggregateSupport.jsonCustomWriteExpression(customWriteExpression, column.getJdbcMapping())));
            }
            this.passThroughUnsetSubExpressions(aggregateColumn);
        }

        protected void passThroughUnsetSubExpressions(SelectableMapping aggregateColumn) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)aggregateColumn.getJdbcMapping().getJdbcType();
            EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
            int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
            for (int i = 0; i < jdbcValueCount; ++i) {
                SelectableMapping selectableMapping = embeddableMappingType.getJdbcValueSelectable(i);
                JsonWriteExpression jsonWriteExpression = this.subExpressions.get(selectableMapping.getSelectableName());
                if (jsonWriteExpression == null) {
                    this.subExpressions.put(selectableMapping.getSelectableName(), new PassThroughExpression(selectableMapping));
                    continue;
                }
                if (!(jsonWriteExpression instanceof AggregateJsonWriteExpression)) continue;
                AggregateJsonWriteExpression writeExpression = (AggregateJsonWriteExpression)jsonWriteExpression;
                writeExpression.passThroughUnsetSubExpressions(selectableMapping);
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("json_object");
            int separator = 40;
            for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                String column = entry.getKey();
                JsonWriteExpression value = entry.getValue();
                String subPath = path + ".\"" + column + "\"";
                sb.append((char)separator);
                if (value instanceof AggregateJsonWriteExpression) {
                    sb.append('\'');
                    sb.append(column);
                    sb.append("':coalesce(");
                    value.append(sb, subPath, translator, expression);
                    sb.append(",json_object())");
                } else {
                    value.append(sb, subPath, translator, expression);
                }
                separator = 44;
            }
            sb.append(')');
        }
    }

    static interface JsonWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }
}

