/*
 * Decompiled with CFR 0.152.
 */
package liquibase.analytics;

import java.util.Map;
import java.util.UUID;
import liquibase.analytics.AnonymousSeed;
import liquibase.analytics.Event;
import lombok.Generated;

public class AnalyticsTrackEvent {
    private final String type = "track";
    private final String userId;
    private final String anonymousId;
    private final String event = "liquibase-command-executed";
    private final Map<String, ?> properties;
    private final Map<String, ?> context;
    private final String messageId = UUID.randomUUID().toString();
    private final String timestamp;

    public static AnalyticsTrackEvent fromLiquibaseEvent(Event event, String userId) {
        AnalyticsTrackEvent analyticsTrackEvent = new AnalyticsTrackEvent(userId, new AnonymousSeed().generateId(), event.getPropertiesAsMap(), null, event.getTimestamp());
        return analyticsTrackEvent;
    }

    @Generated
    public AnalyticsTrackEvent(String userId, String anonymousId, Map<String, ?> properties, Map<String, ?> context, String timestamp) {
        this.userId = userId;
        this.anonymousId = anonymousId;
        this.properties = properties;
        this.context = context;
        this.timestamp = timestamp;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getAnonymousId() {
        return this.anonymousId;
    }

    @Generated
    public String getEvent() {
        return this.event;
    }

    @Generated
    public Map<String, ?> getProperties() {
        return this.properties;
    }

    @Generated
    public Map<String, ?> getContext() {
        return this.context;
    }

    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyticsTrackEvent)) {
            return false;
        }
        AnalyticsTrackEvent other = (AnalyticsTrackEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$anonymousId = this.getAnonymousId();
        String other$anonymousId = other.getAnonymousId();
        if (this$anonymousId == null ? other$anonymousId != null : !this$anonymousId.equals(other$anonymousId)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        Map<String, ?> this$properties = this.getProperties();
        Map<String, ?> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Map<String, ?> this$context = this.getContext();
        Map<String, ?> other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnalyticsTrackEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $anonymousId = this.getAnonymousId();
        result = result * 59 + ($anonymousId == null ? 43 : $anonymousId.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        Map<String, ?> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Map<String, ?> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnalyticsTrackEvent(type=" + this.getType() + ", userId=" + this.getUserId() + ", anonymousId=" + this.getAnonymousId() + ", event=" + this.getEvent() + ", properties=" + this.getProperties() + ", context=" + this.getContext() + ", messageId=" + this.getMessageId() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

