/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.threads;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.Constants;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jdk.jfr.consumer.RecordedEvent;

public final class ThreadCountHandler
implements RecordedEventHandler {
    private static final String METRIC_NAME = "jvm.thread.count";
    private static final String EVENT_NAME = "jdk.JavaThreadStatistics";
    private static final String METRIC_DESCRIPTION = "Number of executing threads";
    private static final Attributes ATTR_DAEMON_TRUE = Attributes.of(Constants.ATTR_DAEMON, (Object)true);
    private static final Attributes ATTR_DAEMON_FALSE = Attributes.of(Constants.ATTR_DAEMON, (Object)false);
    private final List<AutoCloseable> observables = new ArrayList<AutoCloseable>();
    private volatile long activeCount = 0L;
    private volatile long daemonCount = 0L;

    public ThreadCountHandler(Meter meter) {
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder(METRIC_NAME).setDescription(METRIC_DESCRIPTION).setUnit("{thread}").buildWithCallback(measurement -> {
            long d = this.daemonCount;
            measurement.record(d, ATTR_DAEMON_TRUE);
            measurement.record(this.activeCount - d, ATTR_DAEMON_FALSE);
        }));
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.activeCount = ev.getLong("activeCount");
        this.daemonCount = ev.getLong("daemonCount");
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.THREAD_METRICS;
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.ofSeconds(1L));
    }

    @Override
    public void close() {
        RecordedEventHandler.closeObservables(this.observables);
    }
}

