/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayViaElementArgumentReturnTypeResolver;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.internal.TypecheckUtil;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BindingContext;
import org.hibernate.type.BottomType;

public class ArrayConstructorFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final boolean withKeyword;

    public ArrayConstructorFunction(boolean list, boolean withKeyword) {
        super("array" + (list ? "_list" : ""), ArrayConstructorArgumentsValidator.INSTANCE, list ? ArrayViaElementArgumentReturnTypeResolver.VARARGS_LIST_INSTANCE : ArrayViaElementArgumentReturnTypeResolver.VARARGS_INSTANCE, StandardFunctionArgumentTypeResolvers.NULL);
        this.withKeyword = withKeyword;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        int size;
        if (this.withKeyword) {
            sqlAppender.append("array");
        }
        if ((size = arguments.size()) == 0) {
            sqlAppender.append('[');
        } else {
            int separator = 91;
            for (int i = 0; i < size; ++i) {
                SqlAstNode argument = arguments.get(i);
                sqlAppender.append((char)separator);
                argument.accept(walker);
                separator = 44;
            }
        }
        sqlAppender.append(']');
    }

    private static class ArrayConstructorArgumentsValidator
    implements ArgumentsValidator {
        public static final ArgumentsValidator INSTANCE = new ArrayConstructorArgumentsValidator();

        private ArrayConstructorArgumentsValidator() {
        }

        @Override
        public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, BindingContext bindingContext) {
            int size = arguments.size();
            SqmBindableType<?> firstType = null;
            for (int i = 0; i < size; ++i) {
                SqmBindableType<?> argument = arguments.get(i).getExpressible();
                if (firstType == null) {
                    firstType = argument;
                    continue;
                }
                if (TypecheckUtil.areTypesComparable(firstType, argument, bindingContext)) continue;
                throw new FunctionArgumentException(String.format("All array arguments must have a compatible type compatible to the first argument type [%s], but argument %d has type '%s'", firstType.getTypeName(), i + 1, argument.getTypeName()));
            }
        }

        @Override
        public void validateSqlTypes(List<? extends SqlAstNode> arguments, String functionName) {
            int size = arguments.size();
            JdbcMappingContainer firstType = null;
            for (int i = 0; i < size; ++i) {
                JdbcMappingContainer argumentType = ((Expression)arguments.get(i)).getExpressionType();
                if (argumentType == null || argumentType instanceof BottomType) continue;
                if (firstType == null) {
                    firstType = argumentType;
                    continue;
                }
                if (firstType.getSingleJdbcMapping() == argumentType.getSingleJdbcMapping()) continue;
                throw new FunctionArgumentException(String.format("All array arguments must have a type compatible to the first argument type [%s], but argument %d has type '%s'", firstType.getSingleJdbcMapping(), i + 1, argumentType.getSingleJdbcMapping()));
            }
        }
    }
}

