/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder;

import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.internal.OnlyOnceLoggingDenyMeterFilter;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.config.runtime.HttpClientConfig;
import io.quarkus.micrometer.runtime.config.runtime.HttpServerConfig;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Produces;

@Singleton
public class HttpMeterFilterProvider {
    HttpBinderConfiguration binderConfiguration;

    HttpMeterFilterProvider(HttpBinderConfiguration binderConfiguration) {
        this.binderConfiguration = binderConfiguration;
    }

    @Singleton
    @Produces
    public MeterFilter metricsHttpClientUriTagFilter(HttpClientConfig httpClientConfig) {
        if (this.binderConfiguration.isClientEnabled()) {
            return this.maximumAllowableUriTagsFilter(this.binderConfiguration.getHttpClientRequestsName(), httpClientConfig.maxUriTags());
        }
        return null;
    }

    @Singleton
    @Produces
    public MeterFilter metricsHttpServerUriTagFilter(HttpServerConfig httpServerConfig) {
        if (this.binderConfiguration.isServerEnabled()) {
            return this.maximumAllowableUriTagsFilter(this.binderConfiguration.getHttpServerRequestsName(), httpServerConfig.maxUriTags());
        }
        return null;
    }

    @Singleton
    @Produces
    public MeterFilter metricsHttpPushUriTagFilter(HttpServerConfig httpServerConfig) {
        if (this.binderConfiguration.isServerEnabled()) {
            return this.maximumAllowableUriTagsFilter(this.binderConfiguration.getHttpServerPushName(), httpServerConfig.maxUriTags());
        }
        return null;
    }

    @Singleton
    @Produces
    public MeterFilter metricsHttpWebSocketsUriTagFilter(HttpServerConfig httpServerConfig) {
        if (this.binderConfiguration.isServerEnabled()) {
            return this.maximumAllowableUriTagsFilter(this.binderConfiguration.getHttpServerWebSocketConnectionsName(), httpServerConfig.maxUriTags());
        }
        return null;
    }

    MeterFilter maximumAllowableUriTagsFilter(String metricName, int maximumTagValues) {
        OnlyOnceLoggingDenyMeterFilter denyFilter = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number (%s) of URI tags for '%s'. Are you using path parameters?", maximumTagValues, metricName));
        return MeterFilter.maximumAllowableTags((String)metricName, (String)"uri", (int)maximumTagValues, (MeterFilter)denyFilter);
    }
}

