/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.community.dialect.FirebirdSqlAstTranslator;
import org.hibernate.community.dialect.identity.FirebirdIdentityColumnSupport;
import org.hibernate.community.dialect.pagination.FirstSkipLimitHandler;
import org.hibernate.community.dialect.sequence.FirebirdSequenceSupport;
import org.hibernate.community.dialect.sequence.InterbaseSequenceSupport;
import org.hibernate.community.dialect.sequence.SequenceInformationExtractorFirebirdDatabaseImpl;
import org.hibernate.dialect.BooleanDecoder;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.HypotheticalSetWindowEmulation;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.internal.LockingSupportSimple;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.StandardGlobalTemporaryTableStrategy;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceNameExtractorImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.StandardIndexExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.BinaryFloatDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class FirebirdDialect
extends Dialect {
    private static final DatabaseVersion DEFAULT_VERSION = DatabaseVersion.make((Integer)3);
    private static final Pattern FOREIGN_UNIQUE_OR_PRIMARY_KEY_PATTERN = Pattern.compile("violation of .+? constraint \"([^\"]+)\"");
    private static final Pattern CHECK_CONSTRAINT_PATTERN = Pattern.compile("Operation violates CHECK constraint (.+?) on view or table");
    private static final ViolatedConstraintNameExtractor EXTRACTOR = sqle -> {
        String message = sqle.getMessage();
        if (message != null) {
            Matcher foreignUniqueOrPrimaryKeyMatcher = FOREIGN_UNIQUE_OR_PRIMARY_KEY_PATTERN.matcher(message);
            if (foreignUniqueOrPrimaryKeyMatcher.find()) {
                return foreignUniqueOrPrimaryKeyMatcher.group(1);
            }
            Matcher checkConstraintMatcher = CHECK_CONSTRAINT_PATTERN.matcher(message);
            if (checkConstraintMatcher.find()) {
                return checkConstraintMatcher.group(1);
            }
        }
        return null;
    };
    private final FirebirdIndexExporter indexExporter = new FirebirdIndexExporter(this);

    public FirebirdDialect() {
        this(DEFAULT_VERSION);
    }

    public FirebirdDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(DEFAULT_VERSION));
        this.registerKeywords(info);
    }

    public FirebirdDialect(DatabaseVersion version) {
        super(version);
    }

    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case 16 -> {
                if (this.getVersion().isBefore(3)) {
                    yield "smallint";
                }
                yield "boolean";
            }
            case -6 -> "smallint";
            case 93 -> "timestamp";
            case 92 -> "time";
            case 2013 -> {
                if (this.getVersion().isBefore(4)) {
                    yield "time";
                }
                yield "time with time zone";
            }
            case 2014 -> {
                if (this.getVersion().isBefore(4)) {
                    yield "timestamp";
                }
                yield "timestamp with time zone";
            }
            case -2 -> {
                if (this.getVersion().isBefore(4)) {
                    yield "char($l) character set octets";
                }
                yield "binary($l)";
            }
            case -3 -> {
                if (this.getVersion().isBefore(4)) {
                    yield "varchar($l) character set octets";
                }
                yield "varbinary($l)";
            }
            case 2004 -> "blob sub_type binary";
            case 2005, 2011 -> "blob sub_type text";
            default -> super.columnType(sqlTypeCode);
        };
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        if (this.getVersion().isBefore(4, 0)) {
            ddlTypeRegistry.addDescriptor((DdlType)new BinaryFloatDdlType((Dialect)this));
        }
    }

    public int getMaxVarcharLength() {
        return 8191;
    }

    public int getMaxVarbinaryLength() {
        return 32765;
    }

    public int getDefaultStatementBatchSize() {
        return 0;
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return this.getVersion().isSameOrAfter(4, 0) ? TimeZoneSupport.NATIVE : TimeZoneSupport.NONE;
    }

    public String currentTime() {
        return this.getVersion().isSameOrAfter(4) ? "localtime" : "current_time";
    }

    public String currentTimestamp() {
        return this.getVersion().isSameOrAfter(4) ? "localtimestamp" : "current_timestamp";
    }

    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == -7) {
            return jdbcTypeRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return this.getVersion().isBefore(3, 0) ? -7 : super.getPreferredSqlTypeCodeForBoolean();
    }

    public int getFloatPrecision() {
        return this.getVersion().isBefore(4, 0) ? 21 : 24;
    }

    public int getDefaultTimestampPrecision() {
        return 3;
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1000000L;
    }

    public boolean doesRoundTemporalOnOverflow() {
        return false;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        BasicType byteArrayType = basicTypeRegistry.resolve(StandardBasicTypes.BINARY);
        BasicType integerType = basicTypeRegistry.resolve(StandardBasicTypes.INTEGER);
        BasicType doubleType = basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE);
        BasicType characterType = basicTypeRegistry.resolve(StandardBasicTypes.CHARACTER);
        DatabaseVersion version = this.getVersion();
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        functionFactory.aggregates((Dialect)this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.avg_castingNonDoubleArguments((Dialect)this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.concat_pipeOperator();
        functionFactory.cot();
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        if (version.isSameOrAfter(3)) {
            functionFactory.moreHyperbolic();
            functionFactory.stddevPopSamp();
            functionFactory.varPopSamp();
            functionFactory.covarPopSamp();
            functionFactory.corr();
            functionFactory.regrLinearRegressionAggregates();
        }
        functionFactory.log();
        functionFactory.log10();
        functionFactory.pi();
        functionFactory.rand();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.cosh();
        functionFactory.trunc();
        functionFactory.octetLength();
        functionFactory.bitLength();
        functionFactory.substringFromFor();
        functionFactory.overlay();
        functionFactory.insert_overlay();
        functionFactory.reverse();
        functionFactory.bitandorxornot_binAndOrXorNot();
        functionFactory.leastGreatest_minMaxValue();
        if (version.isSameOrAfter(3, 0, 4) || version.isBefore(3) && version.isSameOrAfter(2, 5, 9)) {
            functionFactory.localtimeLocaltimestamp();
        }
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        functionRegistry.registerBinaryTernaryPattern("position", integerType, "position(?1 in ?2)", "position(?1,?2,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, typeConfiguration).setArgumentListSignature("(STRING pattern, STRING string[, INTEGER start])");
        functionRegistry.registerAlternateKey("locate", "position");
        functionRegistry.namedDescriptorBuilder("ascii_val").setExactArgumentCount(1).setInvariantType(integerType).register();
        functionRegistry.registerAlternateKey("ascii", "ascii_val");
        functionRegistry.namedDescriptorBuilder("ascii_char").setExactArgumentCount(1).setInvariantType(characterType).register();
        functionRegistry.registerAlternateKey("chr", "ascii_char");
        functionRegistry.registerAlternateKey("char", "ascii_char");
        functionRegistry.registerPattern("radians", "((?1)*pi()/180e0)", doubleType);
        functionRegistry.registerPattern("degrees", "((?1)*180e0/pi())", doubleType);
        functionFactory.repeat_rpad("char_length");
        if (version.isSameOrAfter(3)) {
            functionFactory.windowFunctions();
            functionFactory.hypotheticalOrderedSetAggregates();
            if (version.isBefore(4)) {
                functionRegistry.register("percent_rank", (SqmFunctionDescriptor)new HypotheticalSetWindowEmulation("percent_rank", StandardBasicTypes.DOUBLE, typeConfiguration));
                functionRegistry.register("cume_dist", (SqmFunctionDescriptor)new HypotheticalSetWindowEmulation("cume_dist", StandardBasicTypes.DOUBLE, typeConfiguration));
            }
            if (version.isSameOrAfter(4)) {
                functionFactory.sha("crypt_hash(?1 using sha256)");
                functionFactory.md5("crypt_hash(?1 using md5)");
                Arrays.asList("sha1", "sha256", "sha512").forEach(hash -> functionRegistry.registerPattern(hash, "crypt_hash(?1 using " + hash + ")", byteArrayType));
                functionRegistry.registerPattern("crc32", "hash(?1 using crc32)", integerType);
                functionFactory.hex("hex_encode(?1)");
            }
        }
        functionFactory.listagg_list("varchar");
        functionFactory.generateSeries_recursive(this.getMaximumSeriesSize(), false, false);
    }

    protected int getMaximumSeriesSize() {
        return 1024;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new FirebirdSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public boolean supportsTruncateWithCast() {
        return false;
    }

    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case INTEGER: 
            case LONG: {
                String result = BooleanDecoder.toInteger((CastType)from);
                if (result == null) break;
                return result;
            }
            case BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("true", "false") : BooleanDecoder.toBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case INTEGER_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("1", "0") : BooleanDecoder.toIntegerBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case YN_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("'Y'", "'N'") : BooleanDecoder.toYesNoBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case TF_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("'T'", "'F'") : BooleanDecoder.toTrueFalseBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case STRING: {
                String result = BooleanDecoder.toString((CastType)from);
                if (result == null) break;
                return "trim(" + result + ")";
            }
        }
        return super.castPattern(from, to);
    }

    public String extractPattern(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.DAY_OF_WEEK, TemporalUnit.DAY_OF_YEAR -> "(" + super.extractPattern(unit) + "+1)";
            case TemporalUnit.QUARTER -> "((extract(month from ?2)+2)/3)";
            case TemporalUnit.EPOCH -> "datediff(second from timestamp '1970-01-01 00:00:00' to ?2)";
            default -> super.extractPattern(unit);
        };
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return switch (unit) {
            case TemporalUnit.NATIVE -> "dateadd((?2) millisecond to ?3)";
            case TemporalUnit.NANOSECOND -> "dateadd((?2)/1e6 millisecond to ?3)";
            case TemporalUnit.WEEK -> "dateadd((?2)*7 day to ?3)";
            case TemporalUnit.QUARTER -> "dateadd((?2)*3 month to ?3)";
            default -> "dateadd(?2 ?1 to ?3)";
        };
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        return switch (unit) {
            case TemporalUnit.NATIVE -> "datediff(millisecond from ?2 to ?3)";
            case TemporalUnit.NANOSECOND -> "datediff(millisecond from ?2 to ?3)*1e6";
            case TemporalUnit.WEEK -> "datediff(day from ?2 to ?3)/7";
            case TemporalUnit.QUARTER -> "datediff(month from ?2 to ?3)/3";
            default -> "datediff(?1 from ?2 to ?3)";
        };
    }

    public boolean supportsTemporalLiteralOffset() {
        return this.getVersion().isSameOrAfter(4, 0);
    }

    public int getDefaultDecimalPrecision() {
        return this.getVersion().isBefore(4, 0) ? 18 : 38;
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getNoColumnsInsertString() {
        return "default values";
    }

    public int getMaxAliasLength() {
        return this.getVersion().isBefore(4, 0) ? 20 : 52;
    }

    public int getMaxIdentifierLength() {
        return this.getVersion().isBefore(4) ? 31 : 63;
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData metadata) throws SQLException {
        builder.setAutoQuoteKeywords(true);
        builder.setAutoQuoteInitialUnderscore(true);
        if (this.getVersion().isSameOrAfter(3, 0)) {
            builder.applyReservedWords(new String[]{"AVG", "BOOLEAN", "CHARACTER_LENGTH", "CHAR_LENGTH", "CORR", "COUNT", "COVAR_POP", "COVAR_SAMP", "EXTRACT", "LOWER", "MAX", "MIN", "OCTET_LENGTH", "POSITION", "REGR_AVGX", "REGR_AVGY", "REGR_COUNT", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXX", "REGR_SXY", "REGR_SYY", "STDDEV_POP", "STDDEV_SAMP", "SUM", "TRIM", "UPPER", "VAR_POP", "VAR_SAMP"});
        } else {
            builder.applyReservedWords(new String[]{"AVG", "CHARACTER_LENGTH", "CHAR_LENGTH", "COUNT", "EXTRACT", "LOWER", "MAX", "MIN", "OCTET_LENGTH", "POSITION", "SUM", "TRIM", "UPPER"});
        }
        return super.buildIdentifierHelper(builder, metadata);
    }

    public boolean canCreateSchema() {
        return false;
    }

    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No create schema syntax supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No drop schema syntax supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsCommentOn() {
        return this.getVersion().isSameOrAfter(2, 0);
    }

    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public int getInExpressionCountLimit() {
        return this.getVersion().isBefore(5) ? 1500 : 65535;
    }

    public boolean supportsExistsInSelect() {
        return this.getVersion().isSameOrAfter(3, 0);
    }

    public boolean supportsPartitionBy() {
        return this.getVersion().isSameOrAfter(3, 0);
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        if (this.getVersion().isBefore(3)) {
            appender.appendSql(bool ? (char)'1' : '0');
        } else {
            appender.appendSql(bool);
        }
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.getVersion().isBefore(3, 0) ? super.getIdentityColumnSupport() : FirebirdIdentityColumnSupport.INSTANCE;
    }

    public SequenceSupport getSequenceSupport() {
        DatabaseVersion version = this.getVersion();
        if (version.isSameOrAfter(4)) {
            return FirebirdSequenceSupport.INSTANCE;
        }
        if (version.isSame(3)) {
            return FirebirdSequenceSupport.FB3_INSTANCE;
        }
        if (version.isSame(2)) {
            return FirebirdSequenceSupport.LEGACY_INSTANCE;
        }
        return InterbaseSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return this.getVersion().isBefore(3, 0) ? "select rdb$generator_name from rdb$generators" : "select rdb$generator_name,rdb$initial_value,rdb$generator_increment from rdb$generators where coalesce(rdb$system_flag,0)=0";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getVersion().isBefore(3, 0) ? SequenceNameExtractorImpl.INSTANCE : SequenceInformationExtractorFirebirdDatabaseImpl.INSTANCE;
    }

    public String getForUpdateString() {
        return " with lock";
    }

    public String getForUpdateSkipLockedString() {
        return this.getVersion().isSameOrAfter(5) ? " with lock skip locked" : " with lock";
    }

    public String getForUpdateSkipLockedString(String aliases) {
        return this.getForUpdateSkipLockedString();
    }

    public LimitHandler getLimitHandler() {
        return this.getVersion().isBefore(3, 0) ? FirstSkipLimitHandler.INSTANCE : OffsetFetchLimitHandler.INSTANCE;
    }

    public String getSelectGUIDString() {
        return this.getVersion().isBefore(2, 1) ? super.getSelectGUIDString() : "select uuid_to_char(gen_uuid()) from rdb$database";
    }

    public LockingSupport getLockingSupport() {
        return LockingSupportSimple.NO_OUTER_JOIN;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select current_timestamp from rdb$database";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public NullOrdering getNullOrdering() {
        return this.getVersion().isSameOrAfter(2, 0) ? NullOrdering.SMALLEST : NullOrdering.LAST;
    }

    public boolean supportsNullPrecedence() {
        return this.getVersion().isSameOrAfter(1, 5);
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public boolean supportsFetchClause(FetchClauseType type) {
        return type == FetchClauseType.ROWS_ONLY && this.getVersion().isSameOrAfter(3);
    }

    public boolean supportsValuesListForInsert() {
        return false;
    }

    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(3, 0);
    }

    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(4, 0);
    }

    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    public boolean supportsRecursiveCTE() {
        return true;
    }

    protected boolean supportsPredicateAsExpression() {
        return this.getVersion().isSameOrAfter(3);
    }

    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    public boolean hasDataTypeBeforeGeneratedAs() {
        return false;
    }

    public String translateExtractField(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.DAY_OF_MONTH -> "day";
            case TemporalUnit.DAY_OF_YEAR -> "yearday";
            case TemporalUnit.DAY_OF_WEEK -> "weekday";
            default -> super.translateExtractField(unit);
        };
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                FirebirdDateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                FirebirdDateTimeUtils.appendAsTimestampWithMillis(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Date)date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (Date)date);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        throw new UnsupportedOperationException("format() function not supported on Firebird");
    }

    public void appendUUIDLiteral(SqlAppender appender, UUID literal) {
        appender.appendSql("char_to_uuid('");
        appender.appendSql(literal.toString());
        appender.appendSql("')");
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode((SQLException)sqlException);
            String sqlExceptionMessage = sqlException.getMessage();
            switch (errorCode) {
                case 0x14000010: {
                    if (sqlExceptionMessage != null && sqlExceptionMessage.contains("update conflicts with concurrent update")) {
                        return new LockTimeoutException(message, sqlException, sql);
                    }
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 335544345: 
                case 335544510: {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                case 335544474: 
                case 335544475: 
                case 335544476: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 335544466: 
                case 336396758: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.FOREIGN_KEY, constraintName);
                }
                case 335544558: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.CHECK, constraintName);
                }
                case 335544665: 
                case 336396991: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, constraintName);
                }
            }
            String exceptionMessage = sqlException.getMessage();
            if (exceptionMessage != null && (exceptionMessage.contains("violation of ") || exceptionMessage.contains("violates CHECK constraint"))) {
                String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                return new ConstraintViolationException(message, sqlException, sql, constraintName);
            }
            return null;
        };
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return this.getVersion().isBefore(2, 1) ? super.getFallbackSqmMutationStrategy(entityDescriptor, runtimeModelCreationContext) : new GlobalTemporaryTableMutationStrategy(entityDescriptor, runtimeModelCreationContext);
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return this.getVersion().isBefore(2, 1) ? super.getFallbackSqmInsertStrategy(entityDescriptor, runtimeModelCreationContext) : new GlobalTemporaryTableInsertStrategy(entityDescriptor, runtimeModelCreationContext);
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.GLOBAL;
    }

    public TemporaryTableStrategy getGlobalTemporaryTableStrategy() {
        return StandardGlobalTemporaryTableStrategy.INSTANCE;
    }

    public String getTemporaryTableCreateOptions() {
        return StandardGlobalTemporaryTableStrategy.INSTANCE.getTemporaryTableCreateOptions();
    }

    public Exporter<Index> getIndexExporter() {
        return this.indexExporter;
    }

    public String getDual() {
        return "rdb$database";
    }

    public String getFromDualForSelectOnly() {
        return " from " + this.getDual();
    }

    public boolean supportsIntersect() {
        return false;
    }

    public boolean supportsSimpleQueryGrouping() {
        return this.getVersion().isSameOrAfter(5);
    }

    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    public boolean supportsNestedWithClause() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    public String getTruncateTableStatement(String tableName) {
        return "delete from " + tableName;
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    private static class FirebirdIndexExporter
    extends StandardIndexExporter {
        public FirebirdIndexExporter(Dialect dialect) {
            super(dialect);
        }

        public String[] getSqlCreateStrings(Index index, Metadata metadata, SqlStringGenerationContext context) {
            String tableName = context.format(index.getTable().getQualifiedTableName());
            Dialect dialect = this.getDialect();
            String indexNameForCreation = index.getQuotedName(dialect);
            String sortOrder = index.getColumnOrderMap().getOrDefault(index.getColumns().get(0), "asc");
            StringBuilder buf = new StringBuilder().append("desc".equalsIgnoreCase(sortOrder) || "descending".equalsIgnoreCase(sortOrder) ? "create desc index " : "create index ").append(indexNameForCreation).append(" on ").append(tableName).append(" (");
            boolean first = true;
            for (Column column : index.getColumns()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(column.getQuotedName(dialect));
            }
            buf.append(')');
            return new String[]{buf.toString()};
        }
    }

    private static final class FirebirdDateTimeUtils {
        private static final DateTimeFormatter OFFSET_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeUtils.DATE_TIME_FORMATTER_TIME).parseLenient().appendOffset("+HH:MM", "+00:00").parseStrict().toFormatter(Locale.ENGLISH);
        private static final DateTimeFormatter OFFSET_DATE_TIME_MILLIS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeUtils.DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS).parseLenient().appendOffset("+HH:MM", "+00:00").parseStrict().toFormatter(Locale.ENGLISH);

        private FirebirdDateTimeUtils() {
        }

        private static void appendAsTime(SqlAppender appender, TemporalAccessor temporalAccessor, boolean supportsOffset, TimeZone jdbcTimeZone) {
            if (supportsOffset && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                OFFSET_TIME.formatTo(temporalAccessor, (Appendable)appender);
            } else {
                DateTimeUtils.appendAsTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)supportsOffset, (TimeZone)jdbcTimeZone);
            }
        }

        public static void appendAsTimestampWithMillis(SqlAppender appender, TemporalAccessor temporalAccessor, boolean supportsOffset, TimeZone jdbcTimeZone) {
            if (supportsOffset && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                OFFSET_DATE_TIME_MILLIS.formatTo(temporalAccessor, (Appendable)appender);
            } else if (supportsOffset && temporalAccessor instanceof Instant) {
                OFFSET_DATE_TIME_MILLIS.formatTo(((Instant)temporalAccessor).atZone(jdbcTimeZone.toZoneId()), (Appendable)appender);
            } else {
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)supportsOffset, (TimeZone)jdbcTimeZone);
            }
        }
    }
}

