/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.common.Profile;
import org.keycloak.common.profile.ProfileConfigResolver;
import org.keycloak.common.util.NetworkUtils;
import org.keycloak.quarkus.runtime.QuarkusProfileConfigResolver;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public final class Environment {
    public static final String KC_CONFIG_REBUILD_CHECK = "kc.config.rebuild-check";
    public static final String KC_CONFIG_BUILT = "kc.config.built";
    private static final String KC_HOME_DIR = "kc.home.dir";
    public static final String NON_SERVER_MODE = "nonserver";
    public static final String PROFILE = "kc.profile";
    public static final String ENV_PROFILE = "KC_PROFILE";
    public static final String DATA_PATH = File.separator + "data";
    public static final String DEFAULT_THEMES_PATH = File.separator + "themes";
    public static final String PROD_PROFILE_VALUE = "prod";
    public static final String LAUNCH_MODE = "kc.launch.mode";

    private Environment() {
    }

    public static Boolean isRebuild() {
        return Boolean.getBoolean("quarkus.launch.rebuild");
    }

    public static String getHomeDir() {
        return System.getProperty(KC_HOME_DIR);
    }

    public static Path getHomePath() {
        String homeDir = Environment.getHomeDir();
        if (homeDir != null) {
            return Paths.get(homeDir, new String[0]);
        }
        return null;
    }

    public static String getDataDir() {
        return Environment.getHomeDir() + DATA_PATH;
    }

    public static String getDefaultThemeRootDir() {
        return Environment.getHomeDir() + DEFAULT_THEMES_PATH;
    }

    public static Path getProvidersPath() {
        Path homePath = Environment.getHomePath();
        if (homePath != null) {
            return homePath.resolve("providers");
        }
        return null;
    }

    public static String getCommand() {
        if (Environment.isWindows()) {
            return "kc.bat";
        }
        return "kc.sh";
    }

    public static void setProfile(String profile) {
        System.setProperty(PROFILE, profile);
        System.setProperty(LaunchMode.current().getProfileKey(), profile);
        System.setProperty("smallrye.config.profile", profile);
        if (Environment.isTestLaunchMode()) {
            System.setProperty("mp.config.profile", profile);
        }
    }

    public static boolean isDevMode() {
        if (org.keycloak.common.util.Environment.isDevMode()) {
            return true;
        }
        return "dev".equals(Configuration.getNonPersistedConfigValue(PROFILE).getValue());
    }

    public static boolean isDevProfile() {
        return Optional.ofNullable(org.keycloak.common.util.Environment.getProfile()).orElse("").equalsIgnoreCase("dev");
    }

    public static boolean isNonServerMode() {
        return NON_SERVER_MODE.equalsIgnoreCase(org.keycloak.common.util.Environment.getProfile());
    }

    public static boolean isWindows() {
        return NetworkUtils.checkForWindows();
    }

    public static void forceDevProfile() {
        Environment.setProfile("dev");
    }

    public static Map<String, File> getProviderFiles() {
        Path providersPath = Environment.getProvidersPath();
        if (providersPath == null) {
            return Collections.emptyMap();
        }
        File providersDir = providersPath.toFile();
        if (!providersDir.exists() || !providersDir.isDirectory()) {
            throw new RuntimeException("The 'providers' directory does not exist or is not a valid directory.");
        }
        return Arrays.stream(providersDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })).collect(Collectors.toMap(File::getName, Function.identity()));
    }

    public static boolean isTestLaunchMode() {
        return "test".equals(System.getProperty(LAUNCH_MODE));
    }

    public static void forceTestLaunchMode() {
        System.setProperty(LAUNCH_MODE, "test");
    }

    public static String getKeycloakModeFromProfile(String profile) {
        if (profile == null || profile.isEmpty()) {
            return "none";
        }
        if (profile.equals(LaunchMode.DEVELOPMENT.getDefaultProfile())) {
            return "development";
        }
        if (profile.equals(LaunchMode.TEST.getDefaultProfile())) {
            return "test";
        }
        if (profile.equals(LaunchMode.NORMAL.getDefaultProfile())) {
            return "production";
        }
        return profile;
    }

    public static boolean isDistribution() {
        if (LaunchMode.current().isDevOrTest()) {
            return false;
        }
        return Environment.getHomeDir() != null;
    }

    public static boolean isRebuildCheck() {
        return Boolean.getBoolean(KC_CONFIG_REBUILD_CHECK);
    }

    public static void setRebuildCheck() {
        System.setProperty(KC_CONFIG_REBUILD_CHECK, "true");
    }

    public static boolean isRebuilt() {
        return Boolean.getBoolean(KC_CONFIG_BUILT);
    }

    public static void setHomeDir(Path path) {
        System.setProperty(KC_HOME_DIR, path.toFile().getAbsolutePath());
    }

    public static synchronized Profile getCurrentOrCreateFeatureProfile() {
        Profile profile = Profile.getInstance();
        if (profile == null) {
            profile = Profile.configure((ProfileConfigResolver[])new ProfileConfigResolver[]{new QuarkusProfileConfigResolver()});
        }
        return profile;
    }

    public static void removeHomeDir() {
        System.getProperties().remove(KC_HOME_DIR);
    }

    public static void setRebuild() {
        System.setProperty("quarkus.launch.rebuild", "true");
    }
}

