/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt.vp;

public class KeyBindingJwtVerificationOpts {
    private final boolean keyBindingRequired;
    private final int allowedMaxAge;
    private final String nonce;
    private final String aud;
    private final boolean validateExpirationClaim;
    private final boolean validateNotBeforeClaim;

    public KeyBindingJwtVerificationOpts(boolean keyBindingRequired, int allowedMaxAge, String nonce, String aud, boolean validateExpirationClaim, boolean validateNotBeforeClaim) {
        this.keyBindingRequired = keyBindingRequired;
        this.allowedMaxAge = allowedMaxAge;
        this.nonce = nonce;
        this.aud = aud;
        this.validateExpirationClaim = validateExpirationClaim;
        this.validateNotBeforeClaim = validateNotBeforeClaim;
    }

    public boolean isKeyBindingRequired() {
        return this.keyBindingRequired;
    }

    public int getAllowedMaxAge() {
        return this.allowedMaxAge;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getAud() {
        return this.aud;
    }

    public boolean mustValidateExpirationClaim() {
        return this.validateExpirationClaim;
    }

    public boolean mustValidateNotBeforeClaim() {
        return this.validateNotBeforeClaim;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean keyBindingRequired = true;
        private int allowedMaxAge = 300;
        private String nonce;
        private String aud;
        private boolean validateExpirationClaim = true;
        private boolean validateNotBeforeClaim = true;

        public Builder withKeyBindingRequired(boolean keyBindingRequired) {
            this.keyBindingRequired = keyBindingRequired;
            return this;
        }

        public Builder withAllowedMaxAge(int allowedMaxAge) {
            this.allowedMaxAge = allowedMaxAge;
            return this;
        }

        public Builder withNonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public Builder withAud(String aud) {
            this.aud = aud;
            return this;
        }

        public Builder withValidateExpirationClaim(boolean validateExpirationClaim) {
            this.validateExpirationClaim = validateExpirationClaim;
            return this;
        }

        public Builder withValidateNotBeforeClaim(boolean validateNotBeforeClaim) {
            this.validateNotBeforeClaim = validateNotBeforeClaim;
            return this;
        }

        public KeyBindingJwtVerificationOpts build() {
            if (this.keyBindingRequired && (this.aud == null || this.nonce == null || this.nonce.isEmpty())) {
                throw new IllegalArgumentException("Missing `nonce` and `aud` claims for replay protection");
            }
            return new KeyBindingJwtVerificationOpts(this.keyBindingRequired, this.allowedMaxAge, this.nonce, this.aud, this.validateExpirationClaim, this.validateNotBeforeClaim);
        }
    }
}

