/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;
import org.hibernate.tool.schema.spi.SqlScriptException;

public class SingleLineSqlScriptExtractor
implements SqlScriptCommandExtractor {
    public static final String SHORT_NAME = "single-line";
    public static final SqlScriptCommandExtractor INSTANCE = new SingleLineSqlScriptExtractor();

    @Override
    public List<String> extractCommands(Reader reader, Dialect dialect) {
        LinkedList<String> statementList = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line = bufferedReader.readLine();
            while (line != null) {
                String trimmedLine = line.trim();
                if (!trimmedLine.isEmpty() && !this.isComment(trimmedLine)) {
                    String command = trimmedLine.endsWith(";") ? trimmedLine.substring(0, trimmedLine.length() - 1) : trimmedLine;
                    statementList.add(command);
                }
                line = bufferedReader.readLine();
            }
            return statementList;
        }
        catch (IOException e) {
            throw new SqlScriptException("Error during sql-script parsing.", e);
        }
    }

    private boolean isComment(String line) {
        return line.startsWith("--") || line.startsWith("//") || line.startsWith("/*");
    }
}

