/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import java.util.Locale;

public enum SortDirection {
    ASCENDING,
    DESCENDING;


    public SortDirection reverse() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> DESCENDING;
            case 1 -> ASCENDING;
        };
    }

    public static SortDirection interpret(String value) {
        if (value == null) {
            return null;
        }
        return switch (value.toLowerCase(Locale.ROOT)) {
            case "asc", "ascending" -> ASCENDING;
            case "desc", "descending" -> DESCENDING;
            default -> throw new IllegalArgumentException("Unknown sort order: " + value);
        };
    }
}

