/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.spi;

import java.lang.reflect.Constructor;
import org.hibernate.InstantiationException;
import org.hibernate.query.TupleTransformer;

public class NativeQueryConstructorTransformer<T>
implements TupleTransformer<T> {
    private final Class<T> resultClass;
    private transient Constructor<T> constructor;

    private Constructor<T> constructor(Object[] elements) {
        if (this.constructor == null) {
            try {
                for (Constructor<?> candidate : this.resultClass.getDeclaredConstructors()) {
                    Class<?>[] parameterTypes = candidate.getParameterTypes();
                    if (parameterTypes.length != elements.length) continue;
                    if (this.constructor == null) {
                        this.constructor = this.resultClass.getDeclaredConstructor(parameterTypes);
                        this.constructor.setAccessible(true);
                        continue;
                    }
                    this.constructor = null;
                    break;
                }
            }
            catch (Exception e) {
                throw new InstantiationException("Cannot instantiate query result type", this.resultClass, e);
            }
            if (this.constructor == null) {
                throw new InstantiationException("Result class must have a single constructor with exactly " + elements.length + " parameters", this.resultClass);
            }
        }
        return this.constructor;
    }

    public NativeQueryConstructorTransformer(Class<T> resultClass) {
        this.resultClass = resultClass;
    }

    @Override
    public T transformTuple(Object[] tuple, String[] aliases) {
        try {
            return this.constructor(tuple).newInstance(tuple);
        }
        catch (Exception e) {
            throw new InstantiationException("Cannot instantiate query result type", this.resultClass, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof NativeQueryConstructorTransformer)) return false;
        NativeQueryConstructorTransformer that = (NativeQueryConstructorTransformer)obj;
        if (this.resultClass != that.resultClass) return false;
        return true;
    }

    public int hashCode() {
        return this.resultClass.hashCode();
    }
}

