/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.LobCreator;

public class StreamBackedBinaryStream
implements BinaryStream {
    private final InputStream stream;
    private final long length;
    private byte[] bytes;

    public StreamBackedBinaryStream(InputStream stream, long length) {
        this.stream = stream;
        this.length = length;
    }

    @Override
    public InputStream getInputStream() {
        return this.stream;
    }

    @Override
    public byte[] getBytes() {
        if (this.bytes == null) {
            try {
                this.bytes = this.stream.readAllBytes();
            }
            catch (IOException e) {
                throw new HibernateException("IOException occurred reading a binary value", e);
            }
        }
        return this.bytes;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Blob asBlob(LobCreator lobCreator) {
        return lobCreator.createBlob(this.stream, this.length);
    }

    @Override
    public void release() {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

