/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.saml.common.util.SecurityActions;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class IDFedLSInputResolver
implements LSResourceResolver {
    protected static final Logger logger = Logger.getLogger(IDFedLSInputResolver.class);
    private static final Map<String, String> schemaLocationMap;

    public static Collection<String> schemas() {
        HashSet<String> schemaValues = new HashSet<String>(schemaLocationMap.values());
        schemaValues.remove("schema/w3c/xmlschema/datatypes.dtd");
        schemaValues.remove("schema/w3c/xmlschema/XMLSchema.dtd");
        logger.info((Object)("Considered the schemas:" + String.valueOf(schemaValues)));
        return schemaValues;
    }

    @Override
    public IDFedLSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (systemId == null) {
            throw new IllegalArgumentException("Expected systemId");
        }
        String loc = schemaLocationMap.get(systemId);
        if (loc == null) {
            return null;
        }
        return new IDFedLSInput(baseURI, loc, publicId, systemId);
    }

    static {
        LinkedHashMap<String, String> schemaLocations = new LinkedHashMap<String, String>();
        schemaLocations.put("datatypes.dtd", "schema/w3c/xmlschema/datatypes.dtd");
        schemaLocations.put("XMLSchema.dtd", "schema/w3c/xmlschema/XMLSchema.dtd");
        schemaLocations.put("http://www.w3.org/2001/XMLSchema.dtd", "schema/w3c/xmlschema/XMLSchema.dtd");
        schemaLocations.put("http://www.w3.org/2001/xml.xsd", "schema/w3c/xmlschema/xml.xsd");
        schemaLocations.put("http://www.w3.org/2000/09/xmldsig#", "schema/w3c/xmldsig/xmldsig-core-schema.xsd");
        schemaLocations.put("http://www.w3.org/TR/2002/REC-xmldsig-core-20020212/xmldsig-core-schema.xsd", "schema/w3c/xmldsig/xmldsig-core-schema.xsd");
        schemaLocations.put("http://www.w3.org/TR/xmldsig-core/xmldsig-core-schema.xsd", "schema/w3c/xmldsig/xmldsig-core-schema.xsd");
        schemaLocations.put("http://www.w3.org/2001/04/xmlenc#", "schema/w3c/xmlenc/xenc-schema.xsd");
        schemaLocations.put("http://www.w3.org/TR/2002/REC-xmlenc-core-20021210/xenc-schema.xsd", "schema/w3c/xmlenc/xenc-schema.xsd");
        schemaLocations.put("access_control-xacml-2.0-context-schema-os.xsd", "schema/xacml/access_control-xacml-2.0-context-schema-os.xsd");
        schemaLocations.put("http://docs.oasis-open.org/xacml/2.0/access_control-xacml-2.0-context-schema-os.xsd", "schema/xacml/access_control-xacml-2.0-context-schema-os.xsd");
        schemaLocations.put("access_control-xacml-2.0-policy-schema-os.xsd", "schema/xacml/access_control-xacml-2.0-policy-schema-os.xsd");
        schemaLocations.put("saml-schema-assertion-2.0.xsd", "schema/saml/v2/saml-schema-assertion-2.0.xsd");
        schemaLocations.put("http://www.oasis-open.org/committees/download.php/11027/sstc-saml-schema-assertion-2.0.xsd", "schema/saml/v2/saml-schema-assertion-2.0.xsd");
        schemaLocations.put("saml-schema-protocol-2.0.xsd", "schema/saml/v2/saml-schema-protocol-2.0.xsd");
        schemaLocations.put("http://www.oasis-open.org/committees/download.php/11026/sstc-saml-schema-protocol-2.0.xsd", "schema/saml/v2/saml-schema-protocol-2.0.xsd");
        schemaLocations.put("saml-schema-metadata-2.0.xsd", "schema/saml/v2/saml-schema-metadata-2.0.xsd");
        schemaLocations.put("saml-schema-x500-2.0.xsd", "schema/saml/v2/saml-schema-x500-2.0.xsd");
        schemaLocations.put("saml-schema-xacml-2.0.xsd", "schema/saml/v2/saml-schema-xacml-2.0.xsd");
        schemaLocations.put("saml-schema-xacml-2.0.xsd", "schema/saml/v2/saml-schema-xacml-2.0.xsd");
        schemaLocations.put("saml-schema-authn-context-2.0.xsd", "schema/saml/v2/saml-schema-authn-context-2.0.xsd");
        schemaLocations.put("saml-schema-authn-context-types-2.0.xsd", "schema/saml/v2/saml-schema-authn-context-types-2.0.xsd");
        schemaLocations.put("saml-schema-assertion-1.0.xsd", "schema/saml/v1/saml-schema-assertion-1.0.xsd");
        schemaLocations.put("oasis-sstc-saml-schema-assertion-1.1.xsd", "schema/saml/v1/oasis-sstc-saml-schema-assertion-1.1.xsd");
        schemaLocations.put("saml-schema-protocol-1.1.xsd", "schema/saml/v1/saml-schema-protocol-1.1.xsd");
        schemaLocations.put("access_control-xacml-2.0-saml-assertion-schema-os.xsd", "schema/saml/v2/access_control-xacml-2.0-saml-assertion-schema-os.xsd");
        schemaLocations.put("access_control-xacml-2.0-saml-protocol-schema-os.xsd", "schema/saml/v2/access_control-xacml-2.0-saml-protocol-schema-os.xsd");
        schemaLocations.put("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "schema/wstrust/v1_3/ws-trust-1.3.xsd");
        schemaLocations.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "schema/wstrust/v1_3/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        schemaLocations.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "schema/wstrust/v1_3/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        schemaLocations.put("http://schemas.xmlsoap.org/ws/2004/09/policy", "schema/wstrust/v1_3/ws-policy.xsd");
        schemaLocations.put("http://schemas.xmlsoap.org/ws/2004/09/policy/ws-policy.xsd", "schema/wstrust/v1_3/ws-policy.xsd");
        schemaLocations.put("http://www.w3.org/2005/08/addressing", "schema/wstrust/v1_3/ws-addr.xsd");
        schemaLocations.put("http://www.w3.org/2006/03/addressing/ws-addr.xsd", "schema/wstrust/v1_3/ws-addr.xsd");
        schemaLocationMap = Collections.unmodifiableMap(schemaLocations);
    }

    public static class IDFedLSInput
    implements LSInput {
        private final String baseURI;
        private final String loc;
        private final String publicId;
        private final String systemId;

        public IDFedLSInput(String baseURI, String loc, String publicID, String systemID) {
            this.baseURI = baseURI;
            this.loc = loc;
            this.publicId = publicID;
            this.systemId = systemID;
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public InputStream getByteStream() {
            InputStream is;
            URL url = SecurityActions.loadResource(this.getClass(), this.loc);
            try {
                is = url.openStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (is == null) {
                throw new RuntimeException("inputstream is null for " + this.loc);
            }
            return is;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public void setSystemId(String systemId) {
        }

        public String toString() {
            return "IDFedLSInput [baseURI=" + this.baseURI + ", loc=" + this.loc + ", publicId=" + this.publicId + ", systemId=" + this.systemId + "]";
        }
    }
}

