/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

import io.smallrye.common.resource.Resource;
import io.smallrye.common.resource.ResourceUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;

public interface ResourceLoader
extends Closeable {
    public static final ResourceLoader EMPTY = path -> null;

    public Resource findResource(String var1) throws IOException;

    default public URL baseUrl() {
        throw new UnsupportedOperationException("Base URL is not supported by this resource loader");
    }

    default public ResourceLoader getChildLoader(String path) {
        String subPath = ResourceUtils.canonicalizeRelativePath(path);
        if (subPath.isEmpty()) {
            return this;
        }
        return p -> this.findResource(subPath + "/" + p);
    }

    default public Manifest manifest() throws IOException {
        Resource resource = this.findResource("META-INF/MANIFEST.MF");
        if (resource == null) {
            return null;
        }
        Manifest manifest = new Manifest();
        try (InputStream is = resource.openStream();){
            manifest.read(is);
        }
        return manifest;
    }

    default public void release() {
    }

    @Override
    default public void close() {
    }
}

