/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.CollectionAttributeCopier;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.cache.IndexReaderConfiguration;
import org.infinispan.configuration.cache.IndexShardingConfiguration;
import org.infinispan.configuration.cache.IndexStartupMode;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.IndexWriterConfiguration;
import org.infinispan.configuration.cache.IndexingMode;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class IndexingConfiguration
extends ConfigurationElement<IndexingConfiguration> {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((Enum)Attribute.ENABLED, (Object)false).immutable().build();
    public static final AttributeDefinition<Map<Class<?>, Class<?>>> KEY_TRANSFORMERS = AttributeDefinition.builder((Enum)Element.KEY_TRANSFORMERS, null, Map.class).copier((AttributeCopier)CollectionAttributeCopier.collectionCopier()).initializer(HashMap::new).immutable().build();
    public static final AttributeDefinition<Set<String>> INDEXED_ENTITIES = AttributeDefinition.builder((Enum)Element.INDEXED_ENTITIES, null, Set.class).copier((AttributeCopier)CollectionAttributeCopier.collectionCopier()).initializer(HashSet::new).build();
    public static final AttributeDefinition<IndexStorage> STORAGE = AttributeDefinition.builder((Enum)Attribute.STORAGE, (Object)((Object)IndexStorage.FILESYSTEM)).immutable().build();
    public static final AttributeDefinition<IndexStartupMode> STARTUP_MODE = AttributeDefinition.builder((Enum)Attribute.STARTUP_MODE, (Object)((Object)IndexStartupMode.NONE)).immutable().build();
    public static final AttributeDefinition<String> PATH = AttributeDefinition.builder((Enum)Attribute.PATH, null, String.class).immutable().build();
    public static final AttributeDefinition<IndexingMode> INDEXING_MODE = AttributeDefinition.builder((Enum)Attribute.INDEXING_MODE, (Object)((Object)IndexingMode.AUTO)).immutable().build();
    private final IndexReaderConfiguration readerConfiguration;
    private final IndexWriterConfiguration writerConfiguration;
    private final IndexShardingConfiguration shardingConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(IndexingConfiguration.class, AbstractTypedPropertiesConfiguration.attributeSet(), new AttributeDefinition[]{KEY_TRANSFORMERS, INDEXED_ENTITIES, ENABLED, STORAGE, STARTUP_MODE, PATH, INDEXING_MODE});
    }

    IndexingConfiguration(AttributeSet attributes, IndexReaderConfiguration readerConfiguration, IndexWriterConfiguration writerConfiguration, IndexShardingConfiguration shardingConfiguration) {
        super((Enum)Element.INDEXING, attributes, new ConfigurationElement[0]);
        this.readerConfiguration = readerConfiguration;
        this.writerConfiguration = writerConfiguration;
        this.shardingConfiguration = shardingConfiguration;
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(ENABLED).get();
    }

    public IndexStorage storage() {
        return (IndexStorage)((Object)this.attributes.attribute(STORAGE).get());
    }

    public IndexStartupMode startupMode() {
        return (IndexStartupMode)((Object)this.attributes.attribute(STARTUP_MODE).get());
    }

    public String path() {
        return (String)this.attributes.attribute(PATH).get();
    }

    public IndexingMode indexingMode() {
        return (IndexingMode)((Object)this.attributes.attribute(INDEXING_MODE).get());
    }

    public Map<Class<?>, Class<?>> keyTransformers() {
        return (Map)this.attributes.attribute(KEY_TRANSFORMERS).get();
    }

    public Set<String> indexedEntityTypes() {
        return (Set)this.attributes.attribute(INDEXED_ENTITIES).get();
    }

    @Deprecated(forRemoval=true, since="11.0")
    public final boolean indexShareable() {
        return false;
    }

    public IndexReaderConfiguration reader() {
        return this.readerConfiguration;
    }

    public IndexWriterConfiguration writer() {
        return this.writerConfiguration;
    }

    public IndexShardingConfiguration sharding() {
        return this.shardingConfiguration;
    }

    public boolean isVolatile() {
        return ((IndexStorage)((Object)this.attributes.attribute(STORAGE).get())).equals((Object)IndexStorage.LOCAL_HEAP);
    }

    public String toString() {
        return this.attributes.toString(null) + ", reader=" + String.valueOf((Object)this.readerConfiguration) + ", writer=" + String.valueOf((Object)this.writerConfiguration) + ", sharding=" + String.valueOf((Object)this.shardingConfiguration);
    }
}

