/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.observers;

import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.QueryEngine;

public class SessionFactoryObserverForNamedQueryValidation
implements SessionFactoryObserver {
    private final Metadata metadata;

    public SessionFactoryObserverForNamedQueryValidation(MetadataImplementor metadata) {
        this.metadata = metadata;
    }

    public void sessionFactoryCreated(SessionFactory factory) {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)factory;
        QueryEngine queryEngine = sessionFactory.getQueryEngine();
        queryEngine.getNamedObjectRepository().prepare(sessionFactory, this.metadata);
        if (sessionFactory.getSessionFactoryOptions().isNamedQueryStartupCheckingEnabled()) {
            queryEngine.validateNamedQueries();
        }
    }
}

