/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.array.ArrayViaElementArgumentReturnTypeResolver;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.internal.AbstractFunctionArgumentTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;

public abstract class AbstractArrayFillFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public AbstractArrayFillFunction(boolean list) {
        super("array_fill" + (list ? "_list" : ""), new ArgumentTypesValidator(null, FunctionParameterType.NO_UNTYPED, FunctionParameterType.INTEGER), list ? ArrayViaElementArgumentReturnTypeResolver.VARARGS_LIST_INSTANCE : ArrayViaElementArgumentReturnTypeResolver.VARARGS_INSTANCE, ArrayFillArgumentsValidator.INSTANCE);
    }

    @Override
    public String getArgumentListSignature() {
        return "(OBJECT element, INTEGER elementCount)";
    }

    private static class ArrayFillArgumentsValidator
    implements AbstractFunctionArgumentTypeResolver {
        public static final FunctionArgumentTypeResolver INSTANCE = new ArrayFillArgumentsValidator();

        private ArrayFillArgumentsValidator() {
        }

        @Override
        public @Nullable MappingModelExpressible<?> resolveFunctionArgumentType(List<? extends SqmTypedNode<?>> arguments, int argumentIndex, SqmToSqlAstConverter converter) {
            if (argumentIndex == 0) {
                BasicType basicType;
                MappingModelExpressible<?> impliedReturnType = converter.resolveFunctionImpliedReturnType();
                if (impliedReturnType instanceof BasicPluralType) {
                    BasicPluralType basicPluralType = (BasicPluralType)impliedReturnType;
                    basicType = basicPluralType.getElementType();
                } else {
                    basicType = null;
                }
                return basicType;
            }
            return converter.getCreationContext().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(Integer.class);
        }
    }
}

