/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.deployment.QuarkusClassVisitor;
import io.quarkus.deployment.QuarkusClassWriter;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.RemovedResourceBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.configuration.ClassLoadingConfig;
import io.quarkus.deployment.index.ConstPoolScanner;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassTransformingBuildStep {
    private static final Logger log = Logger.getLogger(ClassTransformingBuildStep.class);
    private static final Map<String, TransformedClassesBuildItem.TransformedClass> transformedClassesCache = new ConcurrentHashMap<String, TransformedClassesBuildItem.TransformedClass>();
    private static volatile BiFunction<String, byte[], byte[]> lastTransformers;

    public static byte[] transform(String className, byte[] classData) {
        if (lastTransformers == null) {
            return classData;
        }
        return lastTransformers.apply(className, classData);
    }

    private static void reset() {
        lastTransformers = null;
        transformedClassesCache.clear();
    }

    @BuildStep
    TransformedClassesBuildItem handleClassTransformation(List<BytecodeTransformerBuildItem> bytecodeTransformerBuildItems, ApplicationArchivesBuildItem appArchives, LiveReloadBuildItem liveReloadBuildItem, final LaunchModeBuildItem launchModeBuildItem, ClassLoadingConfig classLoadingConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, List<RemovedResourceBuildItem> removedResourceBuildItems, ArchiveRootBuildItem archiveRoot, LaunchModeBuildItem launchMode, PackageConfig packageConfig, ExecutorService buildExecutor, CuratedApplicationShutdownBuildItem shutdown) throws ExecutionException, InterruptedException {
        if (bytecodeTransformerBuildItems.isEmpty() && classLoadingConfig.removedResources().isEmpty() && removedResourceBuildItems.isEmpty()) {
            return new TransformedClassesBuildItem(Collections.emptyMap());
        }
        final HashMap<String, List> bytecodeTransformers = new HashMap<String, List>(bytecodeTransformerBuildItems.size());
        final HashSet<String> noConstScanning = new HashSet<String>();
        final HashMap<String, Set> constScanning = new HashMap<String, Set>();
        HashSet<String> nonCacheable = new HashSet<String>();
        final HashMap<String, Integer> classReaderOptions = new HashMap<String, Integer>();
        for (BytecodeTransformerBuildItem i : bytecodeTransformerBuildItems) {
            bytecodeTransformers.computeIfAbsent(i.getClassToTransform(), h -> new ArrayList()).add(i);
            if (i.getRequireConstPoolEntry() == null || i.getRequireConstPoolEntry().isEmpty()) {
                noConstScanning.add(i.getClassToTransform());
            } else {
                constScanning.computeIfAbsent(i.getClassToTransform(), s -> new HashSet()).addAll(i.getRequireConstPoolEntry());
            }
            if (!i.isCacheable()) {
                nonCacheable.add(i.getClassToTransform());
            }
            classReaderOptions.merge(i.getClassToTransform(), i.getClassReaderOptions(), (oldValue, newValue) -> oldValue | newValue);
        }
        final QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
        ConcurrentHashMap<String, Path> transformedToArchive = new ConcurrentHashMap<String, Path>();
        ConcurrentLinkedDeque<Future<TransformedClassesBuildItem.TransformedClass>> transformed = new ConcurrentLinkedDeque<Future<TransformedClassesBuildItem.TransformedClass>>();
        HashMap<Path, Set<TransformedClassesBuildItem.TransformedClass>> transformedClassesByJar = new HashMap<Path, Set<TransformedClassesBuildItem.TransformedClass>>();
        final ClassLoader transformCl = Thread.currentThread().getContextClassLoader();
        shutdown.addCloseTask(ClassTransformingBuildStep::reset, true);
        lastTransformers = new BiFunction<String, byte[], byte[]>(){

            @Override
            public byte[] apply(String className, byte[] originalBytes) {
                List classTransformers = (List)bytecodeTransformers.get(className);
                if (classTransformers == null) {
                    return originalBytes;
                }
                boolean continueOnFailure = classTransformers.stream().filter(a -> !a.isContinueOnFailure()).findAny().isEmpty();
                List<BiFunction<String, ClassVisitor, ClassVisitor>> visitors = classTransformers.stream().sorted(Comparator.comparingInt(BytecodeTransformerBuildItem::getPriority)).map(BytecodeTransformerBuildItem::getVisitorFunction).filter(Objects::nonNull).collect(Collectors.toList());
                List<BiFunction<String, byte[], byte[]>> preVisitFunctions = classTransformers.stream().sorted(Comparator.comparingInt(BytecodeTransformerBuildItem::getPriority)).map(BytecodeTransformerBuildItem::getInputTransformer).filter(Objects::nonNull).collect(Collectors.toList());
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(transformCl);
                    String classFileName = ClassLoaderHelper.fromClassNameToResourceName((String)className);
                    List archives = cl.getElementsWithResource(classFileName);
                    if (!archives.isEmpty()) {
                        ClassPathElement classPathElement = (ClassPathElement)archives.get(0);
                        byte[] classData = classPathElement.getResource(classFileName).getData();
                        Set constValues = (Set)constScanning.get(className);
                        if (constValues != null && !noConstScanning.contains(className) && !ConstPoolScanner.constPoolEntryPresent(classData, constValues)) {
                            byte[] byArray = originalBytes;
                            return byArray;
                        }
                        byte[] data = ClassTransformingBuildStep.this.transformClass(className, visitors, classData, preVisitFunctions, classReaderOptions.getOrDefault(className, 0));
                        TransformedClassesBuildItem.TransformedClass transformedClass = new TransformedClassesBuildItem.TransformedClass(className, data, classFileName);
                        byte[] byArray = transformedClass.getData();
                        return byArray;
                    }
                    byte[] byArray = originalBytes;
                    return byArray;
                }
                catch (Throwable e) {
                    if (continueOnFailure) {
                        if (log.isDebugEnabled()) {
                            log.errorf(e, "Failed to transform %s", (Object)className);
                        } else {
                            log.errorf("Failed to transform %s", (Object)className);
                        }
                        byte[] byArray = originalBytes;
                        return byArray;
                    }
                    throw e;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
        };
        for (Map.Entry entry : bytecodeTransformers.entrySet()) {
            boolean cacheable;
            final String className = (String)entry.getKey();
            boolean bl = cacheable = !nonCacheable.contains(className);
            if (cacheable && transformedClassesCache.containsKey(className) && liveReloadBuildItem.getChangeInformation() != null && !liveReloadBuildItem.getChangeInformation().getChangedClasses().contains(className)) {
                this.handleTransformedClass(transformedToArchive, transformedClassesByJar, transformedClassesCache.get(className));
                continue;
            }
            final String classFileName = ClassLoaderHelper.fromClassNameToResourceName((String)className);
            List archives = cl.getElementsWithResource(classFileName);
            if (!archives.isEmpty()) {
                final ClassPathElement classPathElement = (ClassPathElement)archives.get(0);
                Path jar = classPathElement.getRoot();
                if (jar == null) {
                    log.warnf("Cannot transform %s as its containing application archive could not be found.", entry.getKey());
                    continue;
                }
                final boolean continueOnFailure = ((List)entry.getValue()).stream().filter(a -> !a.isContinueOnFailure()).findAny().isEmpty();
                final List visitors = ((List)entry.getValue()).stream().sorted(Comparator.comparingInt(BytecodeTransformerBuildItem::getPriority)).map(BytecodeTransformerBuildItem::getVisitorFunction).filter(Objects::nonNull).collect(Collectors.toList());
                final List preVisitFunctions = ((List)entry.getValue()).stream().sorted(Comparator.comparingInt(BytecodeTransformerBuildItem::getPriority)).map(BytecodeTransformerBuildItem::getInputTransformer).filter(Objects::nonNull).collect(Collectors.toList());
                transformedToArchive.put(classFileName, jar);
                transformed.add(buildExecutor.submit(new Callable<TransformedClassesBuildItem.TransformedClass>(){

                    @Override
                    public TransformedClassesBuildItem.TransformedClass call() throws Exception {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        try {
                            byte[] classData = classPathElement.getResource(classFileName).getData();
                            Thread.currentThread().setContextClassLoader(transformCl);
                            Set constValues = (Set)constScanning.get(className);
                            if (constValues != null && !noConstScanning.contains(className) && !ConstPoolScanner.constPoolEntryPresent(classData, constValues)) {
                                TransformedClassesBuildItem.TransformedClass transformedClass = null;
                                return transformedClass;
                            }
                            byte[] data = ClassTransformingBuildStep.this.transformClass(className, visitors, classData, preVisitFunctions, classReaderOptions.getOrDefault(className, 0));
                            TransformedClassesBuildItem.TransformedClass transformedClass = new TransformedClassesBuildItem.TransformedClass(className, data, classFileName);
                            if (cacheable && launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT && classData != null) {
                                transformedClassesCache.put(className, transformedClass);
                            }
                            TransformedClassesBuildItem.TransformedClass transformedClass2 = transformedClass;
                            return transformedClass2;
                        }
                        catch (Throwable e) {
                            if (continueOnFailure) {
                                if (log.isDebugEnabled()) {
                                    log.errorf(e, "Failed to transform %s", (Object)className);
                                } else {
                                    log.errorf("Failed to transform %s", (Object)className);
                                }
                                TransformedClassesBuildItem.TransformedClass transformedClass = null;
                                return transformedClass;
                            }
                            throw e;
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(old);
                        }
                    }
                }));
                continue;
            }
            log.warnf("Cannot transform %s as its containing application archive could not be found.", entry.getKey());
        }
        this.handleRemovedResources(classLoadingConfig, curateOutcomeBuildItem, transformedClassesByJar, removedResourceBuildItems);
        if (!transformed.isEmpty()) {
            for (Future future : transformed) {
                TransformedClassesBuildItem.TransformedClass res = (TransformedClassesBuildItem.TransformedClass)future.get();
                if (res == null) continue;
                this.handleTransformedClass(transformedToArchive, transformedClassesByJar, res);
            }
        }
        if (packageConfig.writeTransformedBytecodeToBuildOutput() && launchMode.getLaunchMode() == LaunchMode.NORMAL) {
            for (Path path : archiveRoot.getRootDirectories()) {
                this.copyTransformedClasses(path, (Set)transformedClassesByJar.get(path));
            }
        }
        return new TransformedClassesBuildItem(transformedClassesByJar);
    }

    private void copyTransformedClasses(Path originalClassesPath, Set<TransformedClassesBuildItem.TransformedClass> transformedClasses) {
        if (transformedClasses == null || transformedClasses.isEmpty()) {
            return;
        }
        for (TransformedClassesBuildItem.TransformedClass transformedClass : transformedClasses) {
            String classFileName = transformedClass.getFileName();
            String[] fileNameParts = classFileName.split("/");
            Path classFilePath = originalClassesPath;
            for (String fileNamePart : fileNameParts) {
                classFilePath = classFilePath.resolve(fileNamePart);
            }
            try {
                Files.write(classFilePath, transformedClass.getData(), StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                log.debug((Object)("Unable to overwrite file '" + String.valueOf(classFilePath.toAbsolutePath()) + "' with transformed class data"));
            }
        }
    }

    private void handleRemovedResources(ClassLoadingConfig classLoadingConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, Map<Path, Set<TransformedClassesBuildItem.TransformedClass>> transformedClassesByJar, List<RemovedResourceBuildItem> removedResourceBuildItems) {
        HashMap<Object, Set> removed = new HashMap<Object, Set>();
        for (Map.Entry<String, Set<String>> entry : classLoadingConfig.removedResources().entrySet()) {
            removed.put(new GACT(entry.getKey().split(":")), entry.getValue());
        }
        for (RemovedResourceBuildItem i : removedResourceBuildItems) {
            removed.computeIfAbsent(i.getArtifact(), k -> new HashSet()).addAll(i.getResources());
        }
        if (!removed.isEmpty()) {
            ApplicationModel applicationModel = curateOutcomeBuildItem.getApplicationModel();
            Collection runtimeDependencies = applicationModel.getRuntimeDependencies();
            ArrayList<ResolvedDependency> allArtifacts = new ArrayList<ResolvedDependency>(runtimeDependencies.size() + 1);
            allArtifacts.addAll(runtimeDependencies);
            allArtifacts.add(applicationModel.getAppArtifact());
            for (ResolvedDependency i : allArtifacts) {
                Set filtered = (Set)removed.remove(i.getKey());
                if (filtered == null) continue;
                for (Path path : i.getResolvedPaths()) {
                    transformedClassesByJar.computeIfAbsent(path, s -> new HashSet()).addAll(filtered.stream().map(file -> new TransformedClassesBuildItem.TransformedClass(null, null, (String)file, false)).collect(Collectors.toSet()));
                }
            }
        }
        if (!removed.isEmpty()) {
            log.warn((Object)("Could not remove configured resources from the following artifacts as they were not found in the model: " + String.valueOf(removed)));
        }
    }

    private byte[] transformClass(String className, List<BiFunction<String, ClassVisitor, ClassVisitor>> visitors, byte[] classData, List<BiFunction<String, byte[], byte[]>> preVisitFunctions, int classReaderOptions) {
        byte[] data;
        for (BiFunction<String, byte[], byte[]> i : preVisitFunctions) {
            classData = i.apply(className, classData);
            if (classData != null) continue;
            return null;
        }
        if (!visitors.isEmpty()) {
            QuarkusClassWriter writer;
            ClassReader cr = new ClassReader(classData);
            QuarkusClassWriter visitor = writer = new QuarkusClassWriter(cr, 3);
            for (BiFunction<String, ClassVisitor, ClassVisitor> i : visitors) {
                visitor = i.apply(className, (ClassVisitor)visitor);
                if (!(visitor instanceof QuarkusClassVisitor)) continue;
                ((QuarkusClassVisitor)((Object)visitor)).setOriginalClassReaderOptions(classReaderOptions);
            }
            cr.accept((ClassVisitor)visitor, classReaderOptions);
            data = writer.toByteArray();
        } else {
            data = classData;
        }
        String debugTransformedClassesDir = BootstrapDebug.transformedClassesDir();
        if (debugTransformedClassesDir != null) {
            File debugPath = new File(debugTransformedClassesDir);
            if (!debugPath.exists()) {
                debugPath.mkdir();
            }
            File classFile = new File(debugPath, ClassLoaderHelper.fromClassNameToResourceName((String)className));
            classFile.getParentFile().mkdirs();
            try (FileOutputStream classWriter = new FileOutputStream(classFile);){
                classWriter.write(data);
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Failed to write transformed class %s", (Object)className);
            }
            log.infof("Wrote transformed class to %s", (Object)classFile.getAbsolutePath());
        }
        return data;
    }

    private void handleTransformedClass(Map<String, Path> transformedToArchive, Map<Path, Set<TransformedClassesBuildItem.TransformedClass>> transformedClassesByJar, TransformedClassesBuildItem.TransformedClass res) {
        transformedClassesByJar.computeIfAbsent(transformedToArchive.get(res.getFileName()), a -> new HashSet()).add(res);
    }
}

