/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.FetchTiming;
import org.hibernate.graph.spi.GraphHelper;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.InitializerProducer;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableInitializerImpl;
import org.hibernate.type.BasicType;

public class EmbeddableFetchImpl
extends AbstractFetchParent
implements EmbeddableResultGraphNode,
Fetch,
InitializerProducer<EmbeddableFetchImpl> {
    private final FetchParent fetchParent;
    private final FetchTiming fetchTiming;
    private final TableGroup tableGroup;
    private final boolean hasTableGroup;
    private final EmbeddableMappingType fetchContainer;
    private final BasicFetch<?> discriminatorFetch;
    private final @Nullable DomainResult<Boolean> nullIndicatorResult;

    public EmbeddableFetchImpl(NavigablePath navigablePath, EmbeddableValuedFetchable embeddedPartDescriptor, FetchParent fetchParent, FetchTiming fetchTiming, boolean hasTableGroup, DomainResultCreationState creationState) {
        super(navigablePath);
        this.fetchContainer = embeddedPartDescriptor.getEmbeddableTypeDescriptor();
        this.fetchParent = fetchParent;
        this.fetchTiming = fetchTiming;
        this.hasTableGroup = hasTableGroup;
        this.tableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().resolveTableGroup(this.getNavigablePath(), np -> {
            TableGroup lhsTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(fetchParent.getNavigablePath());
            TableGroupJoin tableGroupJoin = this.getReferencedMappingContainer().createTableGroupJoin(this.getNavigablePath(), lhsTableGroup, null, null, SqlAstJoinType.INNER, true, false, creationState.getSqlAstCreationState());
            lhsTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        this.discriminatorFetch = creationState.visitEmbeddableDiscriminatorFetch(this, false);
        if (this.fetchContainer.getAggregateMapping() != null) {
            TableReference tableReference = this.tableGroup.resolveTableReference(this.fetchContainer.getAggregateMapping().getContainingTableExpression());
            Expression aggregateExpression = creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlExpression(tableReference, this.fetchContainer.getAggregateMapping());
            BasicType<Boolean> booleanType = creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration().getBasicTypeForJavaType(Boolean.class);
            this.nullIndicatorResult = new NullnessPredicate(aggregateExpression, false, booleanType).createDomainResult(null, creationState);
        } else {
            this.nullIndicatorResult = null;
        }
        this.afterInitialize(this, creationState);
    }

    protected EmbeddableFetchImpl(EmbeddableFetchImpl original) {
        super(original);
        this.fetchContainer = original.getFetchContainer();
        this.fetchParent = original.fetchParent;
        this.fetchTiming = original.fetchTiming;
        this.tableGroup = original.tableGroup;
        this.hasTableGroup = original.hasTableGroup;
        this.discriminatorFetch = original.discriminatorFetch;
        this.nullIndicatorResult = original.nullIndicatorResult;
    }

    @Override
    public FetchTiming getTiming() {
        return this.fetchTiming;
    }

    @Override
    public boolean hasTableGroup() {
        return this.hasTableGroup;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return this.fetchContainer;
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }

    @Override
    public Fetchable getFetchedMapping() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public NavigablePath resolveNavigablePath(Fetchable fetchable) {
        if (fetchable instanceof TableGroupProducer) {
            for (TableGroupJoin tableGroupJoin : this.tableGroup.getTableGroupJoins()) {
                NavigablePath navigablePath = tableGroupJoin.getNavigablePath();
                if (!tableGroupJoin.getJoinedGroup().isFetched() || !fetchable.getFetchableName().equals(navigablePath.getLocalName()) || tableGroupJoin.getJoinedGroup().getModelPart() != fetchable || !NullnessUtil.castNonNull(navigablePath.getParent()).equals(this.getNavigablePath())) continue;
                return navigablePath;
            }
        }
        return super.resolveNavigablePath(fetchable);
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return this.getFetchContainer();
    }

    @Override
    public DomainResultAssembler<?> createAssembler(InitializerParent<?> parent, AssemblerCreationState creationState) {
        Initializer<?> initializer = creationState.resolveInitializer(this, parent, this);
        EmbeddableInitializer<?> embeddableInitializer = initializer.asEmbeddableInitializer();
        return new EmbeddableAssembler(embeddableInitializer);
    }

    @Override
    public Initializer<?> createInitializer(EmbeddableFetchImpl resultGraphNode, InitializerParent<?> parent, AssemblerCreationState creationState) {
        return resultGraphNode.createInitializer((InitializerParent)parent, creationState);
    }

    public EmbeddableInitializer<?> createInitializer(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new EmbeddableInitializerImpl(this, this.discriminatorFetch, this.nullIndicatorResult, parent, creationState, true);
    }

    @Override
    public boolean appliesTo(GraphImplementor<?> graphImplementor, JpaMetamodel metamodel) {
        return GraphHelper.appliesTo(graphImplementor, metamodel.managedType(this.getResultJavaType().getTypeName()));
    }

    @Override
    public FetchParent asFetchParent() {
        return this;
    }

    protected BasicFetch<?> getDiscriminatorFetch() {
        return this.discriminatorFetch;
    }

    protected @Nullable DomainResult<Boolean> getNullIndicatorResult() {
        return this.nullIndicatorResult;
    }
}

