/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Converts;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.internal.AbstractPropertyHolder;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AttributeConversionInfo;
import org.hibernate.boot.model.internal.ClassPropertyHolder;
import org.hibernate.boot.model.internal.CollectionPropertyHolder;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;

public class ComponentPropertyHolder
extends AbstractPropertyHolder {
    private final Component component;
    private final boolean isOrWithinEmbeddedId;
    private final boolean isWithinElementCollection;
    private final Map<XClass, InheritanceState> inheritanceStatePerClass;
    private final String embeddedAttributeName;
    private final Map<String, AttributeConversionInfo> attributeConversionInfoMap;

    public ComponentPropertyHolder(Component component, String path, PropertyData inferredData, PropertyHolder parent, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        super(path, parent, inferredData.getPropertyClass(), context);
        XProperty embeddedXProperty = inferredData.getProperty();
        this.setCurrentProperty(embeddedXProperty);
        this.component = component;
        this.isOrWithinEmbeddedId = parent.isOrWithinEmbeddedId() || HCANNHelper.hasAnnotation((XAnnotatedElement)embeddedXProperty, Id.class, EmbeddedId.class);
        this.isWithinElementCollection = parent.isWithinElementCollection() || parent instanceof CollectionPropertyHolder;
        this.inheritanceStatePerClass = inheritanceStatePerClass;
        if (embeddedXProperty != null) {
            this.embeddedAttributeName = embeddedXProperty.getName();
            this.attributeConversionInfoMap = this.processAttributeConversions(embeddedXProperty);
        } else {
            this.embeddedAttributeName = "";
            this.attributeConversionInfoMap = this.processAttributeConversions(inferredData.getClassOrPluralElement());
        }
    }

    private Map<String, AttributeConversionInfo> processAttributeConversions(XProperty embeddedXProperty) {
        Converts convertsAnnotation;
        HashMap<String, AttributeConversionInfo> infoMap = new HashMap<String, AttributeConversionInfo>();
        XClass embeddableXClass = embeddedXProperty.getType();
        this.processAttributeConversions(embeddableXClass, infoMap);
        Convert convertAnnotation = (Convert)embeddedXProperty.getAnnotation(Convert.class);
        if (convertAnnotation != null) {
            AttributeConversionInfo info = new AttributeConversionInfo(convertAnnotation, (XAnnotatedElement)embeddableXClass);
            if (StringHelper.isEmpty(info.getAttributeName())) {
                throw new IllegalStateException("Convert placed on Embedded attribute must define (sub)attributeName");
            }
            infoMap.put(info.getAttributeName(), info);
        }
        if ((convertsAnnotation = (Converts)embeddedXProperty.getAnnotation(Converts.class)) != null) {
            for (Convert convertAnnotation2 : convertsAnnotation.value()) {
                AttributeConversionInfo info = new AttributeConversionInfo(convertAnnotation2, (XAnnotatedElement)embeddableXClass);
                if (StringHelper.isEmpty(info.getAttributeName())) {
                    throw new IllegalStateException("Convert placed on Embedded attribute must define (sub)attributeName");
                }
                infoMap.put(info.getAttributeName(), info);
            }
        }
        return infoMap;
    }

    private void processAttributeConversions(XClass embeddableXClass, Map<String, AttributeConversionInfo> infoMap) {
        Converts convertsAnnotation;
        Convert convertAnnotation = (Convert)embeddableXClass.getAnnotation(Convert.class);
        if (convertAnnotation != null) {
            AttributeConversionInfo info = new AttributeConversionInfo(convertAnnotation, (XAnnotatedElement)embeddableXClass);
            if (StringHelper.isEmpty(info.getAttributeName())) {
                throw new IllegalStateException("@Convert placed on @Embeddable must define attributeName");
            }
            infoMap.put(info.getAttributeName(), info);
        }
        if ((convertsAnnotation = (Converts)embeddableXClass.getAnnotation(Converts.class)) != null) {
            for (Convert convertAnnotation2 : convertsAnnotation.value()) {
                AttributeConversionInfo info = new AttributeConversionInfo(convertAnnotation2, (XAnnotatedElement)embeddableXClass);
                if (StringHelper.isEmpty(info.getAttributeName())) {
                    throw new IllegalStateException("@Converts placed on @Embeddable must define attributeName");
                }
                infoMap.put(info.getAttributeName(), info);
            }
        }
    }

    private Map<String, AttributeConversionInfo> processAttributeConversions(XClass embeddableXClass) {
        HashMap<String, AttributeConversionInfo> infoMap = new HashMap<String, AttributeConversionInfo>();
        this.processAttributeConversions(embeddableXClass, infoMap);
        return infoMap;
    }

    @Override
    protected String normalizeCompositePath(String attributeName) {
        return this.embeddedAttributeName + "." + attributeName;
    }

    @Override
    protected String normalizeCompositePathForLogging(String attributeName) {
        return this.normalizeCompositePath(attributeName);
    }

    @Override
    public void startingProperty(XProperty property) {
        Converts convertsAnnotation;
        if (property == null) {
            return;
        }
        String path = this.embeddedAttributeName + "." + property.getName();
        if (this.attributeConversionInfoMap.containsKey(path)) {
            return;
        }
        Convert convertAnnotation = (Convert)property.getAnnotation(Convert.class);
        if (convertAnnotation != null) {
            AttributeConversionInfo info = new AttributeConversionInfo(convertAnnotation, (XAnnotatedElement)property);
            this.attributeConversionInfoMap.put(property.getName(), info);
        }
        if ((convertsAnnotation = (Converts)property.getAnnotation(Converts.class)) != null) {
            for (Convert convertAnnotation2 : convertsAnnotation.value()) {
                AttributeConversionInfo info = new AttributeConversionInfo(convertAnnotation2, (XAnnotatedElement)property);
                this.attributeConversionInfoMap.put(property.getName(), info);
            }
        }
    }

    @Override
    protected AttributeConversionInfo locateAttributeConversionInfo(XProperty property) {
        return this.locateAttributeConversionInfo(property.getName());
    }

    @Override
    protected AttributeConversionInfo locateAttributeConversionInfo(String path) {
        String embeddedPath = StringHelper.qualifyConditionally(this.embeddedAttributeName, path);
        AttributeConversionInfo fromParent = this.parent.locateAttributeConversionInfo(embeddedPath);
        if (fromParent != null) {
            return fromParent;
        }
        AttributeConversionInfo fromEmbedded = this.attributeConversionInfoMap.get(embeddedPath);
        if (fromEmbedded != null) {
            return fromEmbedded;
        }
        return this.attributeConversionInfoMap.get(path);
    }

    @Override
    public String getEntityName() {
        return this.component.getComponentClassName();
    }

    @Override
    public void addProperty(Property property, AnnotatedColumns columns, XClass declaringClass) {
        assert (columns == null || property.getValue().getTable() == columns.getTable());
        this.setTable(property.getValue().getTable());
        this.addProperty(property, declaringClass);
    }

    private void setTable(Table table) {
        if (!table.equals(this.getTable())) {
            if (this.component.getPropertySpan() != 0) {
                throw new AnnotationException("Embeddable class '" + this.component.getComponentClassName() + "' has properties mapped to two different tables (all properties of the embeddable class must map to the same table)");
            }
            this.component.setTable(table);
            if (this.parent instanceof ComponentPropertyHolder) {
                ((ComponentPropertyHolder)this.parent).setTable(table);
            }
        }
    }

    @Override
    public Join addJoin(JoinTable joinTable, boolean noDelayInPkColumnCreation) {
        return this.parent.addJoin(joinTable, noDelayInPkColumnCreation);
    }

    @Override
    public Join addJoin(JoinTable joinTable, Table table, boolean noDelayInPkColumnCreation) {
        return this.parent.addJoin(joinTable, table, noDelayInPkColumnCreation);
    }

    @Override
    public String getClassName() {
        return this.component.getComponentClassName();
    }

    @Override
    public String getEntityOwnerClassName() {
        return this.component.getOwner().getClassName();
    }

    public AggregateColumn getAggregateColumn() {
        AggregateColumn aggregateColumn = this.component.getAggregateColumn();
        return aggregateColumn != null ? aggregateColumn : this.component.getParentAggregateColumn();
    }

    @Override
    public Table getTable() {
        return this.component.getTable();
    }

    @Override
    public void addProperty(Property prop, XClass declaringClass) {
        InheritanceState inheritanceState;
        ClassPropertyHolder.handleGenericComponentProperty(prop, this.getContext());
        if (declaringClass != null && (inheritanceState = this.inheritanceStatePerClass.get(declaringClass)) != null && inheritanceState.isEmbeddableSuperclass()) {
            ClassPropertyHolder.addPropertyToMappedSuperclass(prop, declaringClass, this.getContext());
        }
        this.component.addProperty(prop, declaringClass);
    }

    @Override
    public KeyValue getIdentifier() {
        return this.component.getOwner().getIdentifier();
    }

    @Override
    public boolean isOrWithinEmbeddedId() {
        return this.isOrWithinEmbeddedId;
    }

    @Override
    public boolean isWithinElementCollection() {
        return this.isWithinElementCollection;
    }

    @Override
    public PersistentClass getPersistentClass() {
        return this.component.getOwner();
    }

    @Override
    public boolean isComponent() {
        return true;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public void setParentProperty(String parentProperty) {
        this.component.setParentProperty(parentProperty);
    }

    @Override
    public Column[] getOverriddenColumn(String propertyName) {
        String userPropertyName;
        Column[] result = super.getOverriddenColumn(propertyName);
        if (result == null && (userPropertyName = this.extractUserPropertyName("id", propertyName)) != null) {
            result = super.getOverriddenColumn(userPropertyName);
        }
        if (result == null && (userPropertyName = this.extractUserPropertyName("_identifierMapper", propertyName)) != null) {
            result = super.getOverriddenColumn(userPropertyName);
        }
        return result;
    }

    private String extractUserPropertyName(String redundantString, String propertyName) {
        boolean specialCase;
        String className = this.component.getOwner().getClassName();
        boolean bl = specialCase = propertyName.startsWith(className) && propertyName.length() > className.length() + 2 + redundantString.length() && propertyName.substring(className.length() + 1, className.length() + 1 + redundantString.length()).equals(redundantString);
        if (specialCase) {
            return className + propertyName.substring(className.length() + 1 + redundantString.length());
        }
        return null;
    }

    @Override
    public JoinColumn[] getOverriddenJoinColumn(String propertyName) {
        return super.getOverriddenJoinColumn(propertyName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.parent.normalizeCompositePathForLogging(this.embeddedAttributeName) + ")";
    }
}

