/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.LockModeType;
import java.util.Locale;
import org.hibernate.AssertionFailure;
import org.hibernate.LockOptions;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;

public enum LockMode {
    NONE,
    READ,
    OPTIMISTIC,
    OPTIMISTIC_FORCE_INCREMENT,
    WRITE,
    UPGRADE_NOWAIT,
    UPGRADE_SKIPLOCKED,
    PESSIMISTIC_READ,
    PESSIMISTIC_WRITE,
    PESSIMISTIC_FORCE_INCREMENT;


    public static LockMode fromJpaLockMode(LockModeType lockMode) {
        return LockModeTypeHelper.getLockMode(lockMode);
    }

    public static LockModeType toJpaLockMode(LockMode lockMode) {
        return LockModeTypeHelper.getLockModeType(lockMode);
    }

    public LockModeType toJpaLockMode() {
        return LockModeTypeHelper.getLockModeType(this);
    }

    public boolean greaterThan(LockMode mode) {
        return this.level() > mode.level();
    }

    public boolean lessThan(LockMode mode) {
        return this.level() < mode.level();
    }

    public boolean requiresVersion() {
        return this == OPTIMISTIC || this == OPTIMISTIC_FORCE_INCREMENT || this == PESSIMISTIC_FORCE_INCREMENT;
    }

    public String toExternalForm() {
        String externalForm = this.toString().toLowerCase(Locale.ROOT);
        return this == UPGRADE_NOWAIT || this == UPGRADE_SKIPLOCKED ? externalForm.replace('_', '-') : externalForm;
    }

    private int level() {
        switch (this) {
            case NONE: {
                return 0;
            }
            case READ: {
                return 1;
            }
            case OPTIMISTIC: {
                return 2;
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return 3;
            }
            case PESSIMISTIC_READ: {
                return 4;
            }
            case UPGRADE_NOWAIT: 
            case UPGRADE_SKIPLOCKED: 
            case PESSIMISTIC_WRITE: {
                return 5;
            }
            case PESSIMISTIC_FORCE_INCREMENT: 
            case WRITE: {
                return 6;
            }
        }
        throw new AssertionFailure("Unrecognized LockMode: " + String.valueOf((Object)this));
    }

    public static LockMode fromExternalForm(String externalForm) {
        if (externalForm == null) {
            return NONE;
        }
        for (LockMode lockMode : LockMode.values()) {
            if (!lockMode.toExternalForm().equalsIgnoreCase(externalForm)) continue;
            return lockMode;
        }
        if (externalForm.equalsIgnoreCase("upgrade")) {
            return PESSIMISTIC_WRITE;
        }
        throw new IllegalArgumentException("Unable to interpret LockMode reference from incoming external form: " + externalForm);
    }

    public LockOptions toLockOptions() {
        switch (this) {
            case NONE: {
                return LockOptions.NONE;
            }
            case READ: {
                return LockOptions.READ;
            }
            case OPTIMISTIC: {
                return LockOptions.OPTIMISTIC;
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return LockOptions.OPTIMISTIC_FORCE_INCREMENT;
            }
            case UPGRADE_NOWAIT: {
                return LockOptions.UPGRADE_NOWAIT;
            }
            case UPGRADE_SKIPLOCKED: {
                return LockOptions.UPGRADE_SKIPLOCKED;
            }
            case PESSIMISTIC_READ: {
                return LockOptions.PESSIMISTIC_READ;
            }
            case PESSIMISTIC_WRITE: {
                return LockOptions.PESSIMISTIC_WRITE;
            }
            case PESSIMISTIC_FORCE_INCREMENT: {
                return LockOptions.PESSIMISTIC_FORCE_INCREMENT;
            }
            case WRITE: {
                throw new UnsupportedOperationException("WRITE is not a valid LockMode as an argument");
            }
        }
        throw new AssertionFailure("Unrecognized LockMode: " + String.valueOf((Object)this));
    }
}

