/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import org.hibernate.MappingException;

public class DuplicateMappingException
extends MappingException {
    private final String name;
    private final String type;

    public DuplicateMappingException(Type type, String name) {
        this("Duplicate " + type.text + " '" + name + "'", type, name);
    }

    public DuplicateMappingException(String customMessage, Type type, String name) {
        super(customMessage);
        this.type = type.name();
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static enum Type {
        ENTITY("entity definition"),
        COLLECTION("collection definition"),
        TABLE("table mapping"),
        PROPERTY("property mapping"),
        COLUMN("column mapping"),
        COLUMN_BINDING("physical column name mapping for logical column name"),
        NAMED_ENTITY_GRAPH("named entity graph"),
        QUERY("named query"),
        RESULT_SET_MAPPING("SQL result set mapping"),
        PROCEDURE("named stored procedure");

        private final String text;

        private Type(String text) {
            this.text = text;
        }
    }
}

