/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.CompletedApplicationClassPredicateBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.runtime.ArcRecorder;
import io.quarkus.arc.runtime.test.ActivateSessionContextInterceptor;
import io.quarkus.arc.runtime.test.PreloadedTestApplicationClassPredicate;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import java.util.HashSet;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.DotName;

@BuildSteps(onlyIf={IsTest.class})
public class ArcTestSteps {
    @BuildStep
    public void additionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(PreloadedTestApplicationClassPredicate.class));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(ActivateSessionContextInterceptor.class));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem("io.quarkus.test.ActivateSessionContext"));
    }

    @BuildStep
    AnnotationsTransformerBuildItem addInterceptorBinding() {
        return new AnnotationsTransformerBuildItem(AnnotationTransformation.forClasses().whenClass(ActivateSessionContextInterceptor.class).transform(tc -> tc.add(AnnotationInstance.builder((DotName)DotName.createSimple((String)"io.quarkus.test.ActivateSessionContext")).build())));
    }

    @BuildStep
    ApplicationClassPredicateBuildItem appClassPredicate() {
        return new ApplicationClassPredicateBuildItem((Predicate)new Predicate<String>(){

            @Override
            public boolean test(String name) {
                return name.startsWith(ActivateSessionContextInterceptor.class.getName());
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initTestApplicationClassPredicateBean(ArcRecorder recorder, BeanContainerBuildItem beanContainer, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished, CompletedApplicationClassPredicateBuildItem predicate) {
        HashSet<String> applicationBeanClasses = new HashSet<String>();
        for (BeanInfo bean : beanDiscoveryFinished.beanStream().classBeans()) {
            if (!predicate.test(bean.getBeanClass())) continue;
            applicationBeanClasses.add(bean.getBeanClass().toString());
        }
        recorder.initTestApplicationClassPredicate(applicationBeanClasses);
    }
}

