/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.DataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public final class AgroalDataSourceUtil {
    private AgroalDataSourceUtil() {
    }

    public static InjectableInstance<AgroalDataSource> dataSourceInstance(String dataSourceName) {
        return Arc.container().select(AgroalDataSource.class, new Annotation[]{AgroalDataSourceUtil.qualifier(dataSourceName)});
    }

    public static Optional<AgroalDataSource> dataSourceIfActive(String dataSourceName) {
        InjectableInstance<AgroalDataSource> instance = AgroalDataSourceUtil.dataSourceInstance(dataSourceName);
        if (!instance.isResolvable() || instance.getHandle().getBean().isActive()) {
            return Optional.ofNullable((AgroalDataSource)instance.get());
        }
        return Optional.empty();
    }

    public static Set<String> activeDataSourceNames() {
        LinkedHashSet<String> activeNames = new LinkedHashSet<String>();
        for (InstanceHandle handle : Arc.container().select(AgroalDataSource.class, new Annotation[0]).handles()) {
            String name;
            InjectableBean bean = handle.getBean();
            if (bean == null || !bean.isActive() || (name = AgroalDataSourceUtil.dataSourceName((Bean<? extends javax.sql.DataSource>)bean)) == null) continue;
            activeNames.add(name);
        }
        return activeNames;
    }

    public static String dataSourceName(Bean<? extends javax.sql.DataSource> bean) {
        for (Object qualifier : bean.getQualifiers()) {
            if (!(qualifier instanceof DataSource)) continue;
            return ((DataSource)qualifier).value();
        }
        return "<default>";
    }

    public static Annotation qualifier(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return Default.Literal.INSTANCE;
        }
        return new DataSource.DataSourceLiteral(dataSourceName);
    }
}

