/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.profile;

import java.util.Locale;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.FetchMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.Association;

public class Fetch {
    private final @UnknownKeyFor @NonNull @Initialized Association association;
    private final @UnknownKeyFor @NonNull @Initialized FetchStyle method;
    private final @UnknownKeyFor @NonNull @Initialized FetchTiming timing;

    @Deprecated(forRemoval=true)
    public Fetch(@UnknownKeyFor @NonNull @Initialized Association association, @UnknownKeyFor @NonNull @Initialized Style style) {
        this.association = association;
        this.method = style.toFetchStyle();
        this.timing = FetchTiming.IMMEDIATE;
    }

    public Fetch(@UnknownKeyFor @NonNull @Initialized Association association, @UnknownKeyFor @NonNull @Initialized FetchStyle method, @UnknownKeyFor @NonNull @Initialized FetchTiming timing) {
        this.association = association;
        this.method = method;
        this.timing = timing;
    }

    public @UnknownKeyFor @NonNull @Initialized Association getAssociation() {
        return this.association;
    }

    @Deprecated(forRemoval=true)
    public @UnknownKeyFor @NonNull @Initialized Style getStyle() {
        return Style.fromFetchStyle(this.method);
    }

    public @UnknownKeyFor @NonNull @Initialized FetchStyle getMethod() {
        return this.method;
    }

    public @UnknownKeyFor @NonNull @Initialized FetchTiming getTiming() {
        return this.timing;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "Fetch[" + this.method + "{" + this.association.getRole() + "}]";
    }

    @Deprecated(forRemoval=true)
    public static enum Style {
        JOIN,
        SELECT,
        SUBSELECT;


        public @UnknownKeyFor @NonNull @Initialized FetchStyle toFetchStyle() {
            switch (this) {
                case SELECT: {
                    return FetchStyle.SELECT;
                }
                case SUBSELECT: {
                    return FetchStyle.SUBSELECT;
                }
                case JOIN: {
                    return FetchStyle.JOIN;
                }
            }
            throw new AssertionFailure("Unknown Fetch.Style");
        }

        static @UnknownKeyFor @NonNull @Initialized Style fromFetchStyle(@UnknownKeyFor @NonNull @Initialized FetchStyle fetchStyle) {
            switch (fetchStyle) {
                case SELECT: {
                    return SELECT;
                }
                case SUBSELECT: {
                    return SUBSELECT;
                }
                case JOIN: {
                    return JOIN;
                }
            }
            throw new IllegalArgumentException("Unhandled FetchStyle");
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static @UnknownKeyFor @NonNull @Initialized Style parse(@UnknownKeyFor @NonNull @Initialized String name) {
            for (Style style : Style.values()) {
                if (!style.name().equalsIgnoreCase(name)) continue;
                return style;
            }
            return JOIN;
        }

        public static @UnknownKeyFor @NonNull @Initialized Style forMethod(@UnknownKeyFor @NonNull @Initialized FetchMode fetchMode) {
            switch (fetchMode) {
                case JOIN: {
                    return JOIN;
                }
                case SELECT: {
                    return SELECT;
                }
                case SUBSELECT: {
                    return SUBSELECT;
                }
            }
            throw new IllegalArgumentException("Unknown FetchMode");
        }
    }
}

