/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.KeyProvider;
import org.keycloak.keys.KeyProviderFactory;
import org.keycloak.keys.SecretKeyProviderUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ConfigurationValidationHelper;

public abstract class AbstractGeneratedSecretKeyProviderFactory<T extends KeyProvider>
implements KeyProviderFactory<T> {
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        ConfigurationValidationHelper validation = SecretKeyProviderUtils.validateConfiguration(model);
        validation.checkList(Attributes.SECRET_SIZE_PROPERTY, false);
        int size = model.get("secretSize", this.getDefaultKeySize());
        if (!model.contains("secret")) {
            this.generateSecret(model, size);
            this.logger().debugv("Generated secret for {0}", (Object)realm.getName());
        } else {
            int currentSize = Base64Url.decode((String)model.get("secret")).length;
            if (currentSize != size) {
                this.generateSecret(model, size);
                this.logger().debugv("Secret size changed, generating new secret for {0}", (Object)realm.getName());
            }
        }
    }

    private void generateSecret(ComponentModel model, int size) {
        try {
            byte[] secret = SecretGenerator.getInstance().randomBytes(size);
            model.put("secret", Base64Url.encode((byte[])secret));
            String kid = KeycloakModelUtils.generateId();
            model.put("kid", kid);
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to generate secret", t);
        }
    }

    protected abstract Logger logger();

    protected abstract int getDefaultKeySize();
}

