/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.spi;

import java.util.Collection;
import java.util.stream.Stream;

public interface Targetable {
    public String getTarget();

    default public boolean isActiveFor(String target, boolean strictTargetMatching) {
        if (target == null) {
            return true;
        }
        String localTarget = this.getTarget();
        if (strictTargetMatching) {
            return target.equals(localTarget);
        }
        return localTarget == null || localTarget.equals(target);
    }

    public static <T extends Targetable> Stream<T> filteredByTarget(Collection<T> targetables, String target) {
        return Targetable.filteredByTarget(targetables, target, false);
    }

    public static <T extends Targetable> Stream<T> filteredByTarget(Collection<T> targetables, String target, boolean strictTargetMatching) {
        return targetables.stream().filter(targetable -> targetable.isActiveFor(target, strictTargetMatching));
    }
}

