/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DefaultResponseGenerator
implements ResponseGenerator {
    private static final Log log = LogFactory.getLog(DefaultResponseGenerator.class);

    @Override
    public Response getResponse(CacheRpcCommand command, Object returnValue) {
        if (returnValue instanceof Response) {
            return (Response)returnValue;
        }
        if (command.isReturnValueExpected()) {
            return command.isSuccessful() ? SuccessfulResponse.create(returnValue) : UnsuccessfulResponse.create(returnValue);
        }
        if (returnValue != null && log.isTraceEnabled()) {
            log.tracef("Ignoring non-null response for command %s: %s", command, returnValue);
        }
        return null;
    }
}

