/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker;

import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.jaxrs.ResponseBuilderImpl;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.saml.profile.ecp.authenticator.HttpBasicAuthenticator;
import org.keycloak.representations.docker.DockerAccess;
import org.keycloak.representations.docker.DockerError;
import org.keycloak.representations.docker.DockerErrorResponseToken;

public class DockerAuthenticator
extends HttpBasicAuthenticator {
    private static final Logger logger = Logger.getLogger(DockerAuthenticator.class);
    public static final String ID = "docker-http-basic-authenticator";

    @Override
    protected void notValidCredentialsAction(AuthenticationFlowContext context, RealmModel realm, UserModel user) {
        this.invalidUserAction(context, realm, user.getUsername(), context.getSession().getContext().resolveLocale(user));
    }

    @Override
    protected void nullUserAction(AuthenticationFlowContext context, RealmModel realm, String userId) {
        String localeString = Optional.ofNullable(realm.getDefaultLocale()).orElse(Locale.ENGLISH.toString());
        this.invalidUserAction(context, realm, userId, new Locale(localeString));
    }

    @Override
    protected void userDisabledAction(AuthenticationFlowContext context, RealmModel realm, UserModel user, String eventError) {
        context.getEvent().user(user);
        context.getEvent().error(eventError);
        DockerError error = new DockerError("UNAUTHORIZED", "Invalid username or password.", Collections.singletonList(new DockerAccess(context.getAuthenticationSession().getClientNote("scope"))));
        context.failure(AuthenticationFlowError.USER_DISABLED, new ResponseBuilderImpl().status(Response.Status.UNAUTHORIZED).header("Content-Type", (Object)"application/json").entity((Object)new DockerErrorResponseToken(Collections.singletonList(error))).build());
    }

    private void invalidUserAction(AuthenticationFlowContext context, RealmModel realm, String userId, Locale locale) {
        context.getEvent().user(userId);
        context.getEvent().error("invalid_user_credentials");
        DockerError error = new DockerError("UNAUTHORIZED", "Invalid username or password.", Collections.singletonList(new DockerAccess(context.getAuthenticationSession().getClientNote("scope"))));
        context.failure(AuthenticationFlowError.INVALID_USER, new ResponseBuilderImpl().status(Response.Status.UNAUTHORIZED).header("Content-Type", (Object)"application/json").entity((Object)new DockerErrorResponseToken(Collections.singletonList(error))).build());
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }
}

