/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class UseLightweightAccessTokenExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfigurationRepresentation> {
    private final KeycloakSession session;

    public UseLightweightAccessTokenExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "use-lightweight-access-token";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case TOKEN_REQUEST: 
            case TOKEN_REFRESH: 
            case RESOURCE_OWNER_PASSWORD_CREDENTIALS_REQUEST: 
            case SERVICE_ACCOUNT_TOKEN_REQUEST: 
            case BACKCHANNEL_TOKEN_REQUEST: 
            case DEVICE_TOKEN_REQUEST: {
                this.session.setAttribute("client.use.lightweight.access.token.enabled", (Object)true);
            }
        }
    }
}

