/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.Arrays;
import java.util.Locale;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.loader.ast.internal.AbstractEntityBatchLoader;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadChunker;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.internal.SingleIdExecutionContext;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.SqlInPredicateMultiKeyLoader;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class EntityBatchLoaderInPredicate<T>
extends AbstractEntityBatchLoader<T>
implements SqlInPredicateMultiKeyLoader {
    private final int domainBatchSize;
    private final int sqlBatchSize;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final JdbcParametersList jdbcParameters;
    private final SelectStatement sqlAst;
    private final JdbcOperationQuerySelect jdbcSelectOperation;

    public EntityBatchLoaderInPredicate(int domainBatchSize, EntityMappingType entityDescriptor, LoadQueryInfluencers loadQueryInfluencers) {
        super(entityDescriptor, loadQueryInfluencers);
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.domainBatchSize = domainBatchSize;
        int idColumnCount = entityDescriptor.getEntityPersister().getIdentifierType().getColumnSpan(this.sessionFactory);
        this.sqlBatchSize = this.sessionFactory.getJdbcServices().getDialect().getBatchLoadSizingStrategy().determineOptimalBatchLoadSize(idColumnCount, domainBatchSize, false);
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch fetching `%s` entity using padded IN-list : %s (%s)", (Object)entityDescriptor.getEntityName(), (Object)domainBatchSize, (Object)this.sqlBatchSize);
        }
        EntityIdentifierMapping identifierMapping = this.getLoadable().getIdentifierMapping();
        int expectedNumberOfParameters = identifierMapping.getJdbcTypeCount() * this.sqlBatchSize;
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder(expectedNumberOfParameters);
        this.sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.getLoadable(), null, identifierMapping, null, this.sqlBatchSize, loadQueryInfluencers, LockOptions.NONE, jdbcParametersBuilder::add, this.sessionFactory);
        this.jdbcParameters = jdbcParametersBuilder.build();
        assert (this.jdbcParameters.size() == expectedNumberOfParameters);
        this.jdbcSelectOperation = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.sessionFactory, this.sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
    }

    @Override
    public int getDomainBatchSize() {
        return this.domainBatchSize;
    }

    public int getSqlBatchSize() {
        return this.sqlBatchSize;
    }

    @Override
    public final T load(Object pkValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        return this.load(pkValue, null, lockOptions, readOnly, session);
    }

    @Override
    protected Object[] resolveIdsToInitialize(Object id, SharedSessionContractImplementor session) {
        return session.getPersistenceContextInternal().getBatchFetchQueue().getBatchLoadableEntityIds(this.getLoadable(), id, this.domainBatchSize);
    }

    @Override
    protected void initializeEntities(Object[] idsToInitialize, Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Ids to batch-fetch initialize (`%s#%s`) %s", (Object)this.getLoadable().getEntityName(), pkValue, (Object)Arrays.toString(idsToInitialize));
        }
        MultiKeyLoadChunker<Object> chunker = new MultiKeyLoadChunker<Object>(this.sqlBatchSize, this.getLoadable().getIdentifierMapping().getJdbcTypeCount(), this.getLoadable().getIdentifierMapping(), this.jdbcParameters, this.sqlAst, this.jdbcSelectOperation);
        BatchFetchQueue batchFetchQueue = session.getPersistenceContextInternal().getBatchFetchQueue();
        chunker.processChunks(idsToInitialize, this.sqlBatchSize, (jdbcParameterBindings, session1) -> {
            SubselectFetch.RegistrationHandler registrationHandler = SubselectFetch.createRegistrationHandler(batchFetchQueue, this.sqlAst, this.jdbcParameters, jdbcParameterBindings);
            return new SingleIdExecutionContext(pkValue, entityInstance, this.getLoadable().getRootEntityDescriptor(), readOnly, lockOptions, registrationHandler, session);
        }, (key, relativePosition, absolutePosition) -> {
            if (key != null) {
                EntityKey entityKey = session.generateEntityKey(key, this.getLoadable().getEntityPersister());
                batchFetchQueue.removeBatchLoadableEntityKey(entityKey);
            }
        }, startIndex -> {
            if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
                MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Processing entity batch-fetch chunk (`%s#%s`) %s - %s", new Object[]{this.getLoadable().getEntityName(), pkValue, startIndex, startIndex + (this.sqlBatchSize - 1)});
            }
        }, (startIndex, nonNullElementCount) -> {}, session);
    }

    public String toString() {
        return String.format(Locale.ROOT, "EntityBatchLoaderInPredicate(%s [%s (%s)])", this.getLoadable().getEntityName(), this.domainBatchSize, this.sqlBatchSize);
    }
}

