/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.util;

import java.sql.SQLException;
import java.util.Locale;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.util.ClientParser;

public final class NativeSql {
    /*
     * Enabled aggressive block sorting
     */
    public static String parse(String sql, Context context) throws SQLException {
        if (!sql.contains("{")) {
            return sql;
        }
        ClientParser.LexState state = ClientParser.LexState.Normal;
        char lastChar = '\u0000';
        boolean singleQuotes = false;
        int lastEscapePart = 0;
        StringBuilder sb = new StringBuilder();
        char[] query = sql.toCharArray();
        int queryLength = query.length;
        int escapeIdx = 0;
        boolean inEscape = false;
        block13: for (int idx = 0; idx < queryLength; ++idx) {
            char car = query[idx];
            if (!(state != ClientParser.LexState.Escape || car == '\'' && singleQuotes || car == '\"' && !singleQuotes)) {
                state = ClientParser.LexState.String;
                if (!inEscape) {
                    sb.append(car);
                }
                lastChar = car;
                continue;
            }
            switch (car) {
                case '*': {
                    if (state != ClientParser.LexState.Normal || lastChar != '/') break;
                    state = ClientParser.LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state == ClientParser.LexState.SlashStarComment && lastChar == '*') {
                        state = ClientParser.LexState.Normal;
                        break;
                    }
                    if (state != ClientParser.LexState.Normal || lastChar != '/') break;
                    state = ClientParser.LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (state != ClientParser.LexState.Normal) break;
                    state = ClientParser.LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != ClientParser.LexState.Normal || lastChar != '-') break;
                    state = ClientParser.LexState.EOLComment;
                    break;
                }
                case '\n': {
                    if (state != ClientParser.LexState.EOLComment) break;
                    state = ClientParser.LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == ClientParser.LexState.Normal) {
                        state = ClientParser.LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == ClientParser.LexState.String && !singleQuotes) {
                        state = ClientParser.LexState.Normal;
                        break;
                    }
                    if (state != ClientParser.LexState.Escape) break;
                    state = ClientParser.LexState.String;
                    break;
                }
                case '\'': {
                    if (state == ClientParser.LexState.Normal) {
                        state = ClientParser.LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == ClientParser.LexState.String && singleQuotes) {
                        state = ClientParser.LexState.Normal;
                        break;
                    }
                    if (state != ClientParser.LexState.Escape) break;
                    state = ClientParser.LexState.String;
                    break;
                }
                case '\\': {
                    if (state != ClientParser.LexState.String) break;
                    state = ClientParser.LexState.Escape;
                    break;
                }
                case '`': {
                    if (state == ClientParser.LexState.Backtick) {
                        state = ClientParser.LexState.Normal;
                        break;
                    }
                    if (state != ClientParser.LexState.Normal) break;
                    state = ClientParser.LexState.Backtick;
                    break;
                }
                case '{': {
                    if (state != ClientParser.LexState.Normal) break;
                    if (!inEscape) {
                        inEscape = true;
                        lastEscapePart = idx;
                    }
                    ++escapeIdx;
                    break;
                }
                case '}': {
                    if (state != ClientParser.LexState.Normal || !inEscape || --escapeIdx != 0) break;
                    String str = sql.substring(lastEscapePart, idx + 1);
                    String escapedSeq = NativeSql.resolveEscapes(str, context);
                    sb.append(escapedSeq);
                    inEscape = false;
                    continue block13;
                }
            }
            if (!inEscape) {
                sb.append(car);
            }
            lastChar = car;
        }
        if (inEscape) {
            throw new SQLException("Invalid escape sequence , missing closing '}' character in '" + sql + "'");
        }
        return sb.toString();
    }

    private static String resolveEscapes(String escaped, Context context) throws SQLException {
        block13: {
            block12: {
                int endIndex = escaped.length() - 1;
                if (escaped.startsWith("{fn ")) {
                    String resolvedParams = NativeSql.replaceFunctionParameter(escaped.substring(4, endIndex), context);
                    return NativeSql.parse(resolvedParams, context);
                }
                if (escaped.startsWith("{oj ")) {
                    return NativeSql.parse(escaped.substring(4, endIndex), context);
                }
                if (escaped.startsWith("{d ")) {
                    return escaped.substring(3, endIndex);
                }
                if (escaped.startsWith("{t ")) {
                    return escaped.substring(3, endIndex);
                }
                if (escaped.startsWith("{ts ")) {
                    return escaped.substring(4, endIndex);
                }
                if (escaped.startsWith("{d'")) {
                    return escaped.substring(2, endIndex);
                }
                if (escaped.startsWith("{t'")) {
                    return escaped.substring(2, endIndex);
                }
                if (escaped.startsWith("{ts'")) {
                    return escaped.substring(3, endIndex);
                }
                if (escaped.startsWith("{call ") || escaped.startsWith("{CALL ")) {
                    return NativeSql.parse(escaped.substring(1, endIndex), context);
                }
                if (escaped.startsWith("{?")) {
                    return NativeSql.parse(escaped.substring(1, endIndex), context);
                }
                if (!escaped.startsWith("{ ") && !escaped.startsWith("{\n")) break block12;
                for (int i = 2; i < escaped.length(); ++i) {
                    if (Character.isWhitespace(escaped.charAt(i))) continue;
                    return NativeSql.resolveEscapes("{" + escaped.substring(i), context);
                }
                break block13;
            }
            if (!escaped.startsWith("{\r\n")) break block13;
            for (int i = 3; i < escaped.length(); ++i) {
                if (Character.isWhitespace(escaped.charAt(i))) continue;
                return NativeSql.resolveEscapes("{" + escaped.substring(i), context);
            }
        }
        throw new SQLException("unknown escape sequence " + escaped);
    }

    private static String replaceFunctionParameter(String functionString, Context context) {
        String func;
        int index;
        char[] input = functionString.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (index = 0; index < input.length && input[index] == ' '; ++index) {
        }
        while (index < input.length && (input[index] >= 'a' && input[index] <= 'z' || input[index] >= 'A' && input[index] <= 'Z')) {
            sb.append(input[index]);
            ++index;
        }
        switch (func = sb.toString().toLowerCase(Locale.ROOT)) {
            case "convert": {
                int endParam;
                int lastCommaIndex = functionString.lastIndexOf(44);
                int firstParentheses = functionString.indexOf(40);
                String value = functionString.substring(firstParentheses + 1, lastCommaIndex);
                for (index = lastCommaIndex + 1; index < input.length && Character.isWhitespace(input[index]); ++index) {
                }
                for (endParam = index + 1; endParam < input.length && (input[endParam] >= 'a' && input[endParam] <= 'z' || input[endParam] >= 'A' && input[endParam] <= 'Z' || input[endParam] == '_'); ++endParam) {
                }
                String typeParam = new String(input, index, endParam - index).toUpperCase(Locale.ROOT);
                if (typeParam.startsWith("SQL_")) {
                    typeParam = typeParam.substring(4);
                }
                switch (typeParam) {
                    case "BOOLEAN": {
                        return "1=" + value;
                    }
                    case "BIGINT": 
                    case "SMALLINT": 
                    case "TINYINT": {
                        typeParam = "SIGNED INTEGER";
                        break;
                    }
                    case "BIT": {
                        typeParam = "UNSIGNED INTEGER";
                        break;
                    }
                    case "BLOB": 
                    case "VARBINARY": 
                    case "LONGVARBINARY": 
                    case "ROWID": {
                        typeParam = "BINARY";
                        break;
                    }
                    case "NCHAR": 
                    case "CLOB": 
                    case "NCLOB": 
                    case "DATALINK": 
                    case "VARCHAR": 
                    case "NVARCHAR": 
                    case "LONGVARCHAR": 
                    case "LONGNVARCHAR": 
                    case "SQLXML": 
                    case "LONGNCHAR": {
                        typeParam = "CHAR";
                        break;
                    }
                    case "DOUBLE": 
                    case "FLOAT": {
                        if (context.getVersion().isMariaDBServer() || context.getVersion().versionGreaterOrEqual(8, 0, 17)) {
                            typeParam = "DOUBLE";
                            break;
                        }
                        return "0.0+" + value;
                    }
                    case "REAL": 
                    case "NUMERIC": {
                        typeParam = "DECIMAL";
                        break;
                    }
                    case "TIMESTAMP": {
                        typeParam = "DATETIME";
                        break;
                    }
                }
                return new String(input, 0, index) + typeParam + new String(input, endParam, input.length - endParam);
            }
            case "timestampdiff": 
            case "timestampadd": {
                String paramPrefix;
                while (index < input.length && (Character.isWhitespace(input[index]) || input[index] == '(')) {
                    ++index;
                }
                if (index < input.length - 8 && "SQL_TSI_".equals(paramPrefix = new String(input, index, 8))) {
                    return new String(input, 0, index) + new String(input, index + 8, input.length - (index + 8));
                }
                return functionString;
            }
        }
        return functionString;
    }
}

