/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.data.MessageDigestAlgorithm;
import com.webauthn4j.data.SignatureAlgorithm;
import com.webauthn4j.util.AssertUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.jetbrains.annotations.NotNull;

public class SignatureUtil {
    private SignatureUtil() {
    }

    @NotNull
    public static Signature createRS256() {
        return SignatureUtil.createSignature(SignatureAlgorithm.RS256);
    }

    @NotNull
    public static Signature createES256() {
        return SignatureUtil.createSignature(SignatureAlgorithm.ES256);
    }

    @NotNull
    public static Signature createSignature(@NotNull SignatureAlgorithm algorithm) {
        AssertUtil.notNull(algorithm, "algorithm is required; it must not be null");
        try {
            Signature signature = Signature.getInstance(algorithm.getJcaName());
            if (SignatureAlgorithm.PS256.equals(algorithm)) {
                PSSParameterSpec pssSpec = new PSSParameterSpec(MessageDigestAlgorithm.SHA256.getJcaName(), "MGF1", MGF1ParameterSpec.SHA256, 32, 1);
                signature.setParameter(pssSpec);
            } else if (SignatureAlgorithm.PS384.equals(algorithm)) {
                PSSParameterSpec pssSpec = new PSSParameterSpec(MessageDigestAlgorithm.SHA384.getJcaName(), "MGF1", MGF1ParameterSpec.SHA384, 48, 1);
                signature.setParameter(pssSpec);
            } else if (SignatureAlgorithm.PS512.equals(algorithm)) {
                PSSParameterSpec pssSpec = new PSSParameterSpec(MessageDigestAlgorithm.SHA512.getJcaName(), "MGF1", MGF1ParameterSpec.SHA512, 64, 1);
                signature.setParameter(pssSpec);
            }
            return signature;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Deprecated
    @NotNull
    public static Signature createSignature(@NotNull String algorithm) {
        AssertUtil.notNull(algorithm, "algorithm is required; it must not be null");
        try {
            return Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

