/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.Map;
import java.util.Objects;
import org.hibernate.engine.FetchTiming;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.sql.results.graph.EntityGraphTraversalState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;

public class StandardEntityGraphTraversalStateImpl
implements EntityGraphTraversalState {
    private final GraphSemantic graphSemantic;
    private final JpaMetamodel metamodel;
    private GraphImplementor<?> currentGraphContext;

    public StandardEntityGraphTraversalStateImpl(GraphSemantic graphSemantic, RootGraphImplementor<?> rootGraphImplementor, JpaMetamodel metamodel) {
        Objects.requireNonNull(graphSemantic, "graphSemantic cannot be null");
        Objects.requireNonNull(rootGraphImplementor, "rootGraphImplementor cannot be null");
        this.graphSemantic = graphSemantic;
        this.currentGraphContext = rootGraphImplementor;
        this.metamodel = metamodel;
    }

    @Override
    public void backtrack(EntityGraphTraversalState.TraversalResult previousContext) {
        this.currentGraphContext = previousContext.getGraph();
    }

    @Override
    public EntityGraphTraversalState.TraversalResult traverse(FetchParent fetchParent, Fetchable fetchable, boolean exploreKeySubgraph) {
        EntityGraphTraversalState.FetchStrategy fetchStrategy;
        assert (!(fetchable instanceof CollectionPart));
        if (fetchable instanceof NonAggregatedIdentifierMapping) {
            return new EntityGraphTraversalState.TraversalResult(this.currentGraphContext, new EntityGraphTraversalState.FetchStrategy(FetchTiming.IMMEDIATE, true));
        }
        GraphImplementor<?> previousContextRoot = this.currentGraphContext;
        AttributeNode attributeNode = this.appliesTo(fetchParent) ? this.currentGraphContext.findAttributeNode(fetchable.getFetchableName()) : null;
        this.currentGraphContext = null;
        if (attributeNode != null) {
            Class<?> subgraphMapKey;
            Map subgraphMap;
            fetchStrategy = new EntityGraphTraversalState.FetchStrategy(FetchTiming.IMMEDIATE, true);
            if (fetchable instanceof PluralAttributeMapping) {
                PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
                if (exploreKeySubgraph) {
                    subgraphMap = attributeNode.getKeySubGraphMap();
                    subgraphMapKey = this.getEntityCollectionPartJavaClass(pluralAttributeMapping.getIndexDescriptor());
                } else {
                    subgraphMap = attributeNode.getSubGraphMap();
                    subgraphMapKey = this.getEntityCollectionPartJavaClass(pluralAttributeMapping.getElementDescriptor());
                }
            } else {
                assert (!exploreKeySubgraph);
                subgraphMap = attributeNode.getSubGraphMap();
                subgraphMapKey = fetchable.getJavaType().getJavaTypeClass();
            }
            if (subgraphMap != null && subgraphMapKey != null) {
                this.currentGraphContext = subgraphMap.get(subgraphMapKey);
            }
        } else {
            fetchStrategy = this.graphSemantic == GraphSemantic.FETCH ? new EntityGraphTraversalState.FetchStrategy(FetchTiming.DELAYED, false) : null;
        }
        return new EntityGraphTraversalState.TraversalResult(previousContextRoot, fetchStrategy);
    }

    private Class<?> getEntityCollectionPartJavaClass(CollectionPart collectionPart) {
        if (collectionPart instanceof EntityCollectionPart) {
            EntityCollectionPart entityCollectionPart = (EntityCollectionPart)collectionPart;
            return entityCollectionPart.getEntityMappingType().getJavaType().getJavaTypeClass();
        }
        return null;
    }

    private boolean appliesTo(FetchParent fetchParent) {
        return this.currentGraphContext != null && fetchParent.appliesTo(this.currentGraphContext, this.metamodel);
    }
}

