/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.keycloak.config.ConfigKeystoreOptions;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

public final class ConfigKeystorePropertyMappers {
    private static final String SMALLRYE_KEYSTORE_PATH = "smallrye.config.source.keystore.kc-default.path";
    private static final String SMALLRYE_KEYSTORE_PASSWORD = "smallrye.config.source.keystore.kc-default.password";

    private ConfigKeystorePropertyMappers() {
    }

    public static PropertyMapper<?>[] getConfigKeystorePropertyMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(ConfigKeystoreOptions.CONFIG_KEYSTORE).to(SMALLRYE_KEYSTORE_PATH).transformer(ConfigKeystorePropertyMappers::validatePath).paramLabel("config-keystore").build(), PropertyMapper.fromOption(ConfigKeystoreOptions.CONFIG_KEYSTORE_PASSWORD).to(SMALLRYE_KEYSTORE_PASSWORD).transformer(ConfigKeystorePropertyMappers::validatePassword).paramLabel("config-keystore-password").isMasked(true).build(), PropertyMapper.fromOption(ConfigKeystoreOptions.CONFIG_KEYSTORE_TYPE).to("smallrye.config.source.keystore.kc-default.type").paramLabel("config-keystore-type").build()};
    }

    private static String validatePath(String option, ConfigSourceInterceptorContext context) {
        boolean isPasswordDefined;
        if (option == null) {
            return null;
        }
        boolean bl = isPasswordDefined = context.proceed("kc." + ConfigKeystoreOptions.CONFIG_KEYSTORE_PASSWORD.getKey()) != null;
        if (!isPasswordDefined) {
            throw new IllegalArgumentException("config-keystore-password must be specified");
        }
        Path realPath = Path.of(option, new String[0]).toAbsolutePath().normalize();
        if (!Files.exists(realPath, new LinkOption[0])) {
            throw new IllegalArgumentException("config-keystore path does not exist: " + String.valueOf(realPath));
        }
        return realPath.toUri().toString();
    }

    private static String validatePassword(String option, ConfigSourceInterceptorContext context) {
        boolean isPathDefined;
        if (option == null) {
            return null;
        }
        boolean bl = isPathDefined = context.proceed("kc." + ConfigKeystoreOptions.CONFIG_KEYSTORE.getKey()) != null;
        if (!isPathDefined) {
            throw new IllegalArgumentException("config-keystore must be specified");
        }
        return option;
    }
}

