/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.mappers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.resteasy.reactive.jackson.runtime.security.RolesAllowedConfigExpStorage;
import io.quarkus.security.identity.SecurityIdentity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class JacksonMapperUtil {
    public static boolean includeSecureField(String[] rolesAllowed) {
        SecurityIdentity securityIdentity = RolesAllowedHolder.SECURITY_IDENTITY;
        if (securityIdentity == null) {
            return false;
        }
        RolesAllowedConfigExpStorage rolesConfigExpStorage = RolesAllowedHolder.ROLES_ALLOWED_CONFIG_EXP_STORAGE;
        for (String role : rolesAllowed) {
            String[] roles;
            if (rolesConfigExpStorage != null && (roles = rolesConfigExpStorage.getRoles(role)) != null) {
                for (String r : roles) {
                    if (!securityIdentity.hasRole(r)) continue;
                    return true;
                }
                continue;
            }
            if (!securityIdentity.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public static JavaType getGenericRootType(Type genericType, ObjectWriter defaultWriter) {
        JavaType rootType = null;
        if (genericType != null && genericType.getClass() != Class.class && (rootType = defaultWriter.getTypeFactory().constructType(genericType)).getRawClass() == Object.class) {
            rootType = null;
        }
        return rootType;
    }

    public static JavaType[] getGenericsJavaTypes(DeserializationContext context, BeanProperty property) {
        JavaType wrapperType = property != null ? property.getType() : context.getContextualType();
        JavaType[] valueTypes = new JavaType[wrapperType.containedTypeCount()];
        for (int i = 0; i < valueTypes.length; ++i) {
            valueTypes[i] = wrapperType.containedType(0);
        }
        return valueTypes;
    }

    private static class RolesAllowedHolder {
        private static final ArcContainer ARC_CONTAINER = Arc.container();
        private static final SecurityIdentity SECURITY_IDENTITY = RolesAllowedHolder.createSecurityIdentity();
        private static final RolesAllowedConfigExpStorage ROLES_ALLOWED_CONFIG_EXP_STORAGE = RolesAllowedHolder.createRolesAllowedConfigExpStorage();

        private RolesAllowedHolder() {
        }

        private static SecurityIdentity createSecurityIdentity() {
            if (ARC_CONTAINER == null) {
                return null;
            }
            InstanceHandle instance = ARC_CONTAINER.instance(SecurityIdentity.class, new Annotation[0]);
            return instance.isAvailable() ? (SecurityIdentity)instance.get() : null;
        }

        private static RolesAllowedConfigExpStorage createRolesAllowedConfigExpStorage() {
            if (ARC_CONTAINER == null) {
                return null;
            }
            InstanceHandle rolesAllowedConfigExpStorage = ARC_CONTAINER.instance(RolesAllowedConfigExpStorage.class, new Annotation[0]);
            return rolesAllowedConfigExpStorage.isAvailable() ? (RolesAllowedConfigExpStorage)rolesAllowedConfigExpStorage.get() : null;
        }
    }

    public static enum SerializationInclude {
        ALWAYS,
        NON_NULL,
        NON_ABSENT,
        NON_EMPTY;


        public static SerializationInclude decode(Object object, SerializerProvider serializerProvider) {
            JsonInclude.Include include = serializerProvider.getDefaultPropertyInclusion(object.getClass()).getValueInclusion();
            return switch (include) {
                case JsonInclude.Include.NON_EMPTY -> NON_EMPTY;
                case JsonInclude.Include.NON_NULL -> NON_NULL;
                case JsonInclude.Include.NON_ABSENT -> NON_ABSENT;
                default -> ALWAYS;
            };
        }

        public boolean shouldSerialize(Object value) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case ALWAYS -> true;
                case NON_NULL -> {
                    if (value != null) {
                        yield true;
                    }
                    yield false;
                }
                case NON_ABSENT -> this.isPresent(value);
                case NON_EMPTY -> this.hasValue(value);
            };
        }

        private boolean isPresent(Object value) {
            if (value == null) {
                return false;
            }
            if (value instanceof Optional) {
                Optional o = (Optional)value;
                return o.isPresent();
            }
            return true;
        }

        private boolean hasValue(Object value) {
            if (!this.isPresent(value)) {
                return false;
            }
            if (value instanceof String) {
                String s = (String)value;
                return !s.isEmpty();
            }
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                return !c.isEmpty();
            }
            if (value instanceof Map) {
                Map m = (Map)value;
                return !m.isEmpty();
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value) > 0;
            }
            return true;
        }
    }
}

