/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import java.util.Objects;
import org.apache.kafka.streams.errors.TaskIdFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskId
implements Comparable<TaskId> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskId.class);
    public static final String NAMED_TOPOLOGY_DELIMITER = "__";
    private final int subtopology;
    private final int partition;
    private final String topologyName;

    public TaskId(int subtopology, int partition) {
        this(subtopology, partition, null);
    }

    public TaskId(int subtopology, int partition, String topologyName) {
        this.subtopology = subtopology;
        this.partition = partition;
        if (topologyName != null && topologyName.length() == 0) {
            LOG.warn("Empty string passed in for task's namedTopology, since NamedTopology name cannot be empty, we assume this task does not belong to a NamedTopology and downgrade this to null");
            this.topologyName = null;
        } else {
            this.topologyName = topologyName;
        }
    }

    public int subtopology() {
        return this.subtopology;
    }

    public int partition() {
        return this.partition;
    }

    public String topologyName() {
        return this.topologyName;
    }

    public String toString() {
        return this.topologyName != null ? this.topologyName + NAMED_TOPOLOGY_DELIMITER + this.subtopology + "_" + this.partition : this.subtopology + "_" + this.partition;
    }

    public static TaskId parse(String taskIdStr) {
        try {
            int namedTopologyDelimiterIndex = taskIdStr.indexOf(NAMED_TOPOLOGY_DELIMITER);
            if (namedTopologyDelimiterIndex < 0) {
                int index = taskIdStr.indexOf(95);
                int topicGroupId = Integer.parseInt(taskIdStr.substring(0, index));
                int partition = Integer.parseInt(taskIdStr.substring(index + 1));
                return new TaskId(topicGroupId, partition);
            }
            int topicGroupIdIndex = namedTopologyDelimiterIndex + 2;
            int subtopologyPartitionDelimiterIndex = taskIdStr.indexOf(95, topicGroupIdIndex);
            String namedTopology = taskIdStr.substring(0, namedTopologyDelimiterIndex);
            int topicGroupId = Integer.parseInt(taskIdStr.substring(topicGroupIdIndex, subtopologyPartitionDelimiterIndex));
            int partition = Integer.parseInt(taskIdStr.substring(subtopologyPartitionDelimiterIndex + 1));
            return new TaskId(topicGroupId, partition, namedTopology);
        }
        catch (Exception e) {
            throw new TaskIdFormatException(taskIdStr);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskId taskId = (TaskId)o;
        if (this.subtopology != taskId.subtopology || this.partition != taskId.partition) {
            return false;
        }
        if (this.topologyName != null && taskId.topologyName != null) {
            return this.topologyName.equals(taskId.topologyName);
        }
        return this.topologyName == null && taskId.topologyName == null;
    }

    public int hashCode() {
        return Objects.hash(this.subtopology, this.partition, this.topologyName);
    }

    @Override
    public int compareTo(TaskId other) {
        int comparingTopicGroupId;
        if (this.topologyName != null && other.topologyName != null) {
            int comparingNamedTopologies = this.topologyName.compareTo(other.topologyName);
            if (comparingNamedTopologies != 0) {
                return comparingNamedTopologies;
            }
        } else if (this.topologyName != null || other.topologyName != null) {
            LOG.error("Tried to compare this = {} with other = {}, but only one had a valid named topology", (Object)this, (Object)other);
            throw new IllegalStateException("Can't compare a TaskId with a namedTopology to one without");
        }
        return (comparingTopicGroupId = Integer.compare(this.subtopology, other.subtopology)) != 0 ? comparingTopicGroupId : Integer.compare(this.partition, other.partition);
    }
}

