/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.generated;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ProducerSnapshot
implements ApiMessage {
    long crc;
    List<ProducerEntry> producerEntries;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("crc", (Type)Type.UNSIGNED_INT32, "CRC of the snapshot data"), new Field("producer_entries", (Type)new ArrayOf((Type)ProducerEntry.SCHEMA_1), "The entries in the producer table")});
    public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 1;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public ProducerSnapshot(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ProducerSnapshot() {
        this.crc = 0L;
        this.producerEntries = new ArrayList<ProducerEntry>(0);
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 1;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public final void read(Readable _readable, short _version) {
        this.crc = _readable.readUnsignedInt();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field producerEntries was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<ProducerEntry> newCollection = new ArrayList<ProducerEntry>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new ProducerEntry(_readable, _version));
        }
        this.producerEntries = newCollection;
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedInt(this.crc);
        _writable.writeInt(this.producerEntries.size());
        for (ProducerEntry producerEntriesElement : this.producerEntries) {
            producerEntriesElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(4);
        for (ProducerEntry producerEntriesElement : this.producerEntries) {
            producerEntriesElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProducerSnapshot)) {
            return false;
        }
        ProducerSnapshot other = (ProducerSnapshot)obj;
        if (this.crc != other.crc) {
            return false;
        }
        if (this.producerEntries == null ? other.producerEntries != null : !this.producerEntries.equals(other.producerEntries)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + ((int)(this.crc >> 32) ^ (int)this.crc);
        hashCode = 31 * hashCode + (this.producerEntries == null ? 0 : this.producerEntries.hashCode());
        return hashCode;
    }

    public ProducerSnapshot duplicate() {
        ProducerSnapshot _duplicate = new ProducerSnapshot();
        _duplicate.crc = this.crc;
        ArrayList<ProducerEntry> newProducerEntries = new ArrayList<ProducerEntry>(this.producerEntries.size());
        for (ProducerEntry _element : this.producerEntries) {
            newProducerEntries.add(_element.duplicate());
        }
        _duplicate.producerEntries = newProducerEntries;
        return _duplicate;
    }

    public String toString() {
        return "ProducerSnapshot(crc=" + this.crc + ", producerEntries=" + MessageUtil.deepToString(this.producerEntries.iterator()) + ")";
    }

    public long crc() {
        return this.crc;
    }

    public List<ProducerEntry> producerEntries() {
        return this.producerEntries;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ProducerSnapshot setCrc(long v) {
        if (v < 0L || v > 0xFFFFFFFFL) {
            throw new RuntimeException("Invalid value " + v + " for unsigned int field.");
        }
        this.crc = v;
        return this;
    }

    public ProducerSnapshot setProducerEntries(List<ProducerEntry> v) {
        this.producerEntries = v;
        return this;
    }

    public static class ProducerEntry
    implements Message {
        long producerId;
        short epoch;
        int lastSequence;
        long lastOffset;
        int offsetDelta;
        long timestamp;
        int coordinatorEpoch;
        long currentTxnFirstOffset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("producer_id", (Type)Type.INT64, "The producer ID"), new Field("epoch", (Type)Type.INT16, "Current epoch of the producer"), new Field("last_sequence", (Type)Type.INT32, "Last written sequence of the producer"), new Field("last_offset", (Type)Type.INT64, "Last written offset of the producer"), new Field("offset_delta", (Type)Type.INT32, "The difference of the last sequence and first sequence in the last written batch"), new Field("timestamp", (Type)Type.INT64, "Max timestamp from the last written entry"), new Field("coordinator_epoch", (Type)Type.INT32, "The epoch of the last transaction coordinator to send an end transaction marker"), new Field("current_txn_first_offset", (Type)Type.INT64, "The first offset of the on-going transaction (-1 if there is none)")});
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public ProducerEntry(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ProducerEntry() {
            this.producerId = 0L;
            this.epoch = 0;
            this.lastSequence = 0;
            this.lastOffset = 0L;
            this.offsetDelta = 0;
            this.timestamp = 0L;
            this.coordinatorEpoch = 0;
            this.currentTxnFirstOffset = 0L;
        }

        public short lowestSupportedVersion() {
            return 1;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public final void read(Readable _readable, short _version) {
            this.producerId = _readable.readLong();
            this.epoch = _readable.readShort();
            this.lastSequence = _readable.readInt();
            this.lastOffset = _readable.readLong();
            this.offsetDelta = _readable.readInt();
            this.timestamp = _readable.readLong();
            this.coordinatorEpoch = _readable.readInt();
            this.currentTxnFirstOffset = _readable.readLong();
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeLong(this.producerId);
            _writable.writeShort(this.epoch);
            _writable.writeInt(this.lastSequence);
            _writable.writeLong(this.lastOffset);
            _writable.writeInt(this.offsetDelta);
            _writable.writeLong(this.timestamp);
            _writable.writeInt(this.coordinatorEpoch);
            _writable.writeLong(this.currentTxnFirstOffset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(8);
            _size.addBytes(2);
            _size.addBytes(4);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProducerEntry)) {
                return false;
            }
            ProducerEntry other = (ProducerEntry)obj;
            if (this.producerId != other.producerId) {
                return false;
            }
            if (this.epoch != other.epoch) {
                return false;
            }
            if (this.lastSequence != other.lastSequence) {
                return false;
            }
            if (this.lastOffset != other.lastOffset) {
                return false;
            }
            if (this.offsetDelta != other.offsetDelta) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            if (this.coordinatorEpoch != other.coordinatorEpoch) {
                return false;
            }
            if (this.currentTxnFirstOffset != other.currentTxnFirstOffset) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
            hashCode = 31 * hashCode + this.epoch;
            hashCode = 31 * hashCode + this.lastSequence;
            hashCode = 31 * hashCode + ((int)(this.lastOffset >> 32) ^ (int)this.lastOffset);
            hashCode = 31 * hashCode + this.offsetDelta;
            hashCode = 31 * hashCode + ((int)(this.timestamp >> 32) ^ (int)this.timestamp);
            hashCode = 31 * hashCode + this.coordinatorEpoch;
            hashCode = 31 * hashCode + ((int)(this.currentTxnFirstOffset >> 32) ^ (int)this.currentTxnFirstOffset);
            return hashCode;
        }

        public ProducerEntry duplicate() {
            ProducerEntry _duplicate = new ProducerEntry();
            _duplicate.producerId = this.producerId;
            _duplicate.epoch = this.epoch;
            _duplicate.lastSequence = this.lastSequence;
            _duplicate.lastOffset = this.lastOffset;
            _duplicate.offsetDelta = this.offsetDelta;
            _duplicate.timestamp = this.timestamp;
            _duplicate.coordinatorEpoch = this.coordinatorEpoch;
            _duplicate.currentTxnFirstOffset = this.currentTxnFirstOffset;
            return _duplicate;
        }

        public String toString() {
            return "ProducerEntry(producerId=" + this.producerId + ", epoch=" + this.epoch + ", lastSequence=" + this.lastSequence + ", lastOffset=" + this.lastOffset + ", offsetDelta=" + this.offsetDelta + ", timestamp=" + this.timestamp + ", coordinatorEpoch=" + this.coordinatorEpoch + ", currentTxnFirstOffset=" + this.currentTxnFirstOffset + ")";
        }

        public long producerId() {
            return this.producerId;
        }

        public short epoch() {
            return this.epoch;
        }

        public int lastSequence() {
            return this.lastSequence;
        }

        public long lastOffset() {
            return this.lastOffset;
        }

        public int offsetDelta() {
            return this.offsetDelta;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public int coordinatorEpoch() {
            return this.coordinatorEpoch;
        }

        public long currentTxnFirstOffset() {
            return this.currentTxnFirstOffset;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ProducerEntry setProducerId(long v) {
            this.producerId = v;
            return this;
        }

        public ProducerEntry setEpoch(short v) {
            this.epoch = v;
            return this;
        }

        public ProducerEntry setLastSequence(int v) {
            this.lastSequence = v;
            return this;
        }

        public ProducerEntry setLastOffset(long v) {
            this.lastOffset = v;
            return this;
        }

        public ProducerEntry setOffsetDelta(int v) {
            this.offsetDelta = v;
            return this;
        }

        public ProducerEntry setTimestamp(long v) {
            this.timestamp = v;
            return this;
        }

        public ProducerEntry setCoordinatorEpoch(int v) {
            this.coordinatorEpoch = v;
            return this;
        }

        public ProducerEntry setCurrentTxnFirstOffset(long v) {
            this.currentTxnFirstOffset = v;
            return this;
        }
    }
}

