/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.metadata.DelegationTokenRecord;
import org.apache.kafka.common.metadata.RemoveDelegationTokenRecord;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.metadata.DelegationTokenData;
import org.apache.kafka.server.common.MetadataVersion;

public final class DelegationTokenDelta {
    private final DelegationTokenImage image;
    private final Map<String, Optional<DelegationTokenData>> changes = new HashMap<String, Optional<DelegationTokenData>>();

    public DelegationTokenDelta(DelegationTokenImage image) {
        this.image = image;
    }

    public void finishSnapshot() {
        for (String tokenId : this.image.tokens().keySet()) {
            if (this.changes.containsKey(tokenId)) continue;
            this.changes.put(tokenId, Optional.empty());
        }
    }

    public DelegationTokenImage image() {
        return this.image;
    }

    public Map<String, Optional<DelegationTokenData>> changes() {
        return this.changes;
    }

    public void replay(DelegationTokenRecord record) {
        this.changes.put(record.tokenId(), Optional.of(DelegationTokenData.fromRecord(record)));
    }

    public void replay(RemoveDelegationTokenRecord record) {
        this.changes.put(record.tokenId(), Optional.empty());
    }

    public void handleMetadataVersionChange(MetadataVersion changedMetadataVersion) {
    }

    public DelegationTokenImage apply() {
        HashMap<String, DelegationTokenData> newTokens = new HashMap<String, DelegationTokenData>();
        for (Map.Entry<String, DelegationTokenData> entry : this.image.tokens().entrySet()) {
            Optional<DelegationTokenData> change = this.changes.get(entry.getKey());
            if (change == null) {
                newTokens.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!change.isPresent()) continue;
            newTokens.put(entry.getKey(), change.get());
        }
        for (Map.Entry<String, Object> entry : this.changes.entrySet()) {
            if (newTokens.containsKey(entry.getKey()) || !((Optional)entry.getValue()).isPresent()) continue;
            newTokens.put(entry.getKey(), (DelegationTokenData)((Optional)entry.getValue()).get());
        }
        return new DelegationTokenImage(newTokens);
    }

    public String toString() {
        return "DelegationTokenDelta(changes=" + String.valueOf(this.changes) + ")";
    }
}

