/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.BrokerFeatures;
import org.apache.kafka.server.ClientMetricsManager;
import org.apache.kafka.server.common.FinalizedFeatures;

public class DefaultApiVersionManager
implements ApiVersionManager {
    private final ApiMessageType.ListenerType listenerType;
    private final Supplier<Optional<NodeApiVersions>> nodeApiVersionsSupplier;
    private final BrokerFeatures brokerFeatures;
    private final MetadataCache metadataCache;
    private final boolean enableUnstableLastVersion;
    private final Optional<ClientMetricsManager> clientMetricsManager;

    public DefaultApiVersionManager(ApiMessageType.ListenerType listenerType, Supplier<Optional<NodeApiVersions>> nodeApiVersionsSupplier, BrokerFeatures brokerFeatures, MetadataCache metadataCache, boolean enableUnstableLastVersion, Optional<ClientMetricsManager> clientMetricsManager) {
        this.listenerType = listenerType;
        this.nodeApiVersionsSupplier = nodeApiVersionsSupplier;
        this.brokerFeatures = brokerFeatures;
        this.metadataCache = metadataCache;
        this.enableUnstableLastVersion = enableUnstableLastVersion;
        this.clientMetricsManager = clientMetricsManager;
    }

    @Override
    public boolean enableUnstableLastVersion() {
        return this.enableUnstableLastVersion;
    }

    @Override
    public ApiMessageType.ListenerType listenerType() {
        return this.listenerType;
    }

    @Override
    public ApiVersionsResponse apiVersionResponse(int throttleTimeMs, boolean alterFeatureLevel0) {
        FinalizedFeatures finalizedFeatures = this.metadataCache.features();
        Optional<NodeApiVersions> controllerApiVersions = this.nodeApiVersionsSupplier.get();
        boolean clientTelemetryEnabled = this.clientMetricsManager.map(ClientMetricsManager::isTelemetryReceiverConfigured).orElse(false);
        ApiVersionsResponseData.ApiVersionCollection apiVersions = controllerApiVersions.map(nodeApiVersions -> ApiVersionsResponse.controllerApiVersions((NodeApiVersions)nodeApiVersions, (ApiMessageType.ListenerType)this.listenerType, (boolean)this.enableUnstableLastVersion, (boolean)clientTelemetryEnabled)).orElseGet(() -> ApiVersionsResponse.brokerApiVersions((ApiMessageType.ListenerType)this.listenerType, (boolean)this.enableUnstableLastVersion, (boolean)clientTelemetryEnabled));
        return new ApiVersionsResponse.Builder().setThrottleTimeMs(throttleTimeMs).setApiVersions(apiVersions).setSupportedFeatures(this.brokerFeatures.supportedFeatures()).setFinalizedFeatures(finalizedFeatures.finalizedFeatures()).setFinalizedFeaturesEpoch(finalizedFeatures.finalizedFeaturesEpoch()).setAlterFeatureLevel0(alterFeatureLevel0).build();
    }

    @Override
    public FinalizedFeatures features() {
        return this.metadataCache.features();
    }
}

