/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.FetchPartitionStatus;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.server.LogReadResult;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0005U4Aa\u0003\u0007\u0001#!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00111\u0003!\u0011!Q\u0001\n5CQ\u0001\u0017\u0001\u0005\u0002eCQ\u0001\u0019\u0001\u0005B\u0005DQ!\u001c\u0001\u0005B9DQA\u001d\u0001\u0005BMDQ\u0001\u001e\u0001\u0005BM\u0014A\u0002R3mCf,GMR3uG\"T!!\u0004\b\u0002\rM,'O^3s\u0015\u0005y\u0011!B6bM.\f7\u0001A\n\u0004\u0001Iq\u0002CA\n\u001d\u001b\u0005!\"BA\u000b\u0017\u0003%\u0001XO]4bi>\u0014\u0018P\u0003\u0002\u000e/)\u0011q\u0002\u0007\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014x-\u0003\u0002\u001e)\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\u001c\t\u0003?\tj\u0011\u0001\t\u0006\u0003C9\tQ!\u001e;jYNL!a\t\u0011\u0003\u000f1{wmZ5oO\u00061\u0001/\u0019:b[N\u0004\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u00071|wM\u0003\u0002+-\u000591\u000f^8sC\u001e,\u0017B\u0001\u0017(\u0005-1U\r^2i!\u0006\u0014\u0018-\\:\u0002)\u0019,Go\u00195QCJ$\u0018\u000e^5p]N#\u0018\r^;t!\ryCGN\u0007\u0002a)\u0011\u0011GM\u0001\u000bG>dG.Z2uS>t'\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0002$aA*fcB!q\u0007\u000f\u001eA\u001b\u0005\u0011\u0014BA\u001d3\u0005\u0019!V\u000f\u001d7feA\u00111HP\u0007\u0002y)\u0011QhF\u0001\u0007G>lWn\u001c8\n\u0005}b$\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o!\t\t%)D\u0001\r\u0013\t\u0019EB\u0001\u000bGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8Ti\u0006$Xo]\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\t\te)\u0003\u0002H\u0019\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018!B9v_R\f\u0007CA!K\u0013\tYEB\u0001\u0007SKBd\u0017nY1Rk>$\u0018-\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB!qG\u0014)V\u0013\ty%GA\u0005Gk:\u001cG/[8ocA\u0019q\u0006N)\u0011\t]B$H\u0015\t\u0003MMK!\u0001V\u0014\u0003%\u0019+Go\u00195QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0003oYK!a\u0016\u001a\u0003\tUs\u0017\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\ri[F,\u00180`!\t\t\u0005\u0001C\u0003%\r\u0001\u0007Q\u0005C\u0003.\r\u0001\u0007a\u0006C\u0003E\r\u0001\u0007Q\tC\u0003I\r\u0001\u0007\u0011\nC\u0003M\r\u0001\u0007Q*\u0001\u0005u_N#(/\u001b8h)\u0005\u0011\u0007CA2k\u001d\t!\u0007\u000e\u0005\u0002fe5\taM\u0003\u0002h!\u00051AH]8pizJ!!\u001b\u001a\u0002\rA\u0013X\rZ3g\u0013\tYGN\u0001\u0004TiJLgn\u001a\u0006\u0003SJ\n1\u0002\u001e:z\u0007>l\u0007\u000f\\3uKR\tq\u000e\u0005\u00028a&\u0011\u0011O\r\u0002\b\u0005>|G.Z1o\u00031yg.\u0012=qSJ\fG/[8o)\u0005)\u0016AC8o\u0007>l\u0007\u000f\\3uK\u0002")
public class DelayedFetch
extends DelayedOperation
implements Logging {
    private final FetchParams params;
    private final Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String toString() {
        return "DelayedFetch(params=" + this.params + ", numPartitions=" + this.fetchPartitionStatus.size() + ")";
    }

    public boolean tryComplete() {
        boolean bl;
        Object object = new Object();
        try {
            IntRef accumulatedSize = IntRef.create((int)0);
            this.fetchPartitionStatus.foreach((Function1 & Serializable)x0$1 -> {
                DelayedFetch.$anonfun$tryComplete$1(this, object, accumulatedSize, x0$1);
                return BoxedUnit.UNIT;
            });
            if (accumulatedSize.elem < this.params.minBytes) {
                return false;
            }
            bl = this.forceComplete();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public void onExpiration() {
        if (this.params.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
            return;
        }
        DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
    }

    public void onComplete() {
        Seq fetchInfos = (Seq)this.fetchPartitionStatus.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                FetchPartitionStatus status = (FetchPartitionStatus)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)status.fetchInfo());
            }
            throw new MatchError(null);
        });
        Seq fetchPartitionData = (Seq)this.replicaManager.readFromLog(this.params, (Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>>)fetchInfos, this.quota, true).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$2._1();
                LogReadResult result = (LogReadResult)x0$2._2();
                boolean isReassignmentFetch = $this.params.isFromFollower() && $this.replicaManager.isAddingReplica(tp.topicPartition(), $this.params.replicaId);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)result.toFetchPartitionData(isReassignmentFetch));
            }
            throw new MatchError(null);
        });
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    public static final /* synthetic */ void $anonfun$tryComplete$1(DelayedFetch $this, Object nonLocalReturnKey1$1, IntRef accumulatedSize$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition topicIdPartition = (TopicIdPartition)x0$1._1();
            FetchPartitionStatus fetchStatus = (FetchPartitionStatus)x0$1._2();
            LogOffsetMetadata fetchOffset = fetchStatus.startOffsetMetadata();
            Optional fetchLeaderEpoch = fetchStatus.fetchInfo().currentLeaderEpoch;
            try {
                LogOffsetMetadata logOffsetMetadata = fetchOffset;
                LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata.UNKNOWN_OFFSET_METADATA;
                if (logOffsetMetadata == null ? logOffsetMetadata2 != null : !logOffsetMetadata.equals(logOffsetMetadata2)) {
                    LogOffsetMetadata logOffsetMetadata3;
                    Partition partition = $this.replicaManager.getPartitionOrException(topicIdPartition.topicPartition());
                    LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(fetchLeaderEpoch, $this.params.fetchOnlyLeader());
                    FetchIsolation fetchIsolation = $this.params.isolation;
                    if (FetchIsolation.LOG_END.equals(fetchIsolation)) {
                        logOffsetMetadata3 = offsetSnapshot.logEndOffset;
                    } else if (FetchIsolation.HIGH_WATERMARK.equals(fetchIsolation)) {
                        logOffsetMetadata3 = offsetSnapshot.highWatermark;
                    } else if (FetchIsolation.TXN_COMMITTED.equals(fetchIsolation)) {
                        logOffsetMetadata3 = offsetSnapshot.lastStableOffset;
                    } else {
                        throw new MatchError((Object)fetchIsolation);
                    }
                    LogOffsetMetadata endOffset = logOffsetMetadata3;
                    if (fetchOffset.messageOffset > endOffset.messageOffset) {
                        $this.debug((Function0<String>)(Function0 & Serializable)() -> "Satisfying fetch " + $this + " since it is fetching later segments of partition " + topicIdPartition + ".");
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                    }
                    if (fetchOffset.messageOffset < endOffset.messageOffset) {
                        if (fetchOffset.onOlderSegment(endOffset)) {
                            $this.debug((Function0<String>)(Function0 & Serializable)() -> "Satisfying fetch " + $this + " immediately since it is fetching older segments.");
                            if (!$this.params.isFromFollower() || !$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId)) {
                                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                            }
                        } else if (fetchOffset.onSameSegment(endOffset)) {
                            int bytesAvailable = package$.MODULE$.min(endOffset.positionDiff(fetchOffset), fetchStatus.fetchInfo().maxBytes);
                            if (!$this.params.isFromFollower() || !$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId)) {
                                accumulatedSize$1.elem += bytesAvailable;
                            }
                        }
                    }
                    fetchStatus.fetchInfo().lastFetchedEpoch.ifPresent(fetchEpoch -> {
                        OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(fetchLeaderEpoch, Predef$.MODULE$.Integer2int(fetchEpoch), false);
                        if (epochEndOffset.errorCode() != Errors.NONE.code() || epochEndOffset.endOffset() == -1L || epochEndOffset.leaderEpoch() == -1) {
                            $this.debug((Function0<String>)(Function0 & Serializable)() -> "Could not obtain last offset for leader epoch for partition " + topicIdPartition + ", epochEndOffset=" + epochEndOffset + ".");
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                        }
                        if (epochEndOffset.leaderEpoch() < Predef$.MODULE$.Integer2int(fetchEpoch) || epochEndOffset.endOffset() < fetchStatus$1.fetchInfo().fetchOffset) {
                            $this.debug((Function0<String>)(Function0 & Serializable)() -> "Satisfying fetch " + $this + " since it has diverging epoch requiring truncation for partition " + topicIdPartition + " epochEndOffset=" + epochEndOffset + " fetchEpoch=" + fetchEpoch + " fetchOffset=" + fetchStatus$1.fetchInfo().fetchOffset + ".");
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                        }
                    });
                }
            }
            catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> "Broker is no longer the leader or follower of " + topicIdPartition + ", satisfy " + $this + " immediately");
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
            }
            catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> "Broker no longer knows of partition " + topicIdPartition + ", satisfy " + $this + " immediately");
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
            }
            catch (KafkaStorageException kafkaStorageException) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> "Partition " + topicIdPartition + " is in an offline log directory, satisfy " + $this + " immediately");
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
            }
            catch (FencedLeaderEpochException fencedLeaderEpochException) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> "Broker is the leader of partition " + topicIdPartition + ", but the requested epoch " + fetchLeaderEpoch + " is fenced by the latest leader epoch, satisfy " + $this + " immediately");
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
            }
            return;
        }
        throw new MatchError(null);
    }

    public DelayedFetch(FetchParams params, Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus, ReplicaManager replicaManager, ReplicaQuota quota, Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.params = params;
        this.fetchPartitionStatus = fetchPartitionStatus;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.responseCallback = responseCallback;
        super(params.maxWaitMs);
    }
}

