/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

final class KVTree<K, V>
implements Map.Entry<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final KVTree<?, ?> EMPTY = new KVTree();
    private final int height;
    private final int size;
    private final KVTree<K, V> left;
    private final K key;
    private final V value;
    private final KVTree<K, V> right;

    private KVTree() {
        this.height = 0;
        this.size = 0;
        this.left = null;
        this.key = null;
        this.value = null;
        this.right = null;
    }

    private KVTree(KVTree<K, V> left, K key, V value, KVTree<K, V> right) {
        if (left.height + 1 < right.height || left.height > right.height + 1) {
            throw new IllegalArgumentException();
        }
        this.height = 1 + Math.max(left.height, right.height);
        this.size = left.size + 1 + right.size;
        this.left = left;
        this.key = key;
        this.value = value;
        this.right = right;
    }

    private static <K, V> KVTree<K, V> join(KVTree<K, V> left, K key, V value, KVTree<K, V> right) {
        int leftHeight = left.height;
        int rightHeight = right.height;
        if (leftHeight <= rightHeight + 1 && leftHeight + 1 >= rightHeight) {
            return new KVTree<K, V>(left, key, value, right);
        }
        if (leftHeight < rightHeight) {
            if (right.height == left.height + 2 && right.left.height > right.right.height) {
                return new KVTree<K, V>(new KVTree<K, V>(left, key, value, right.left.left), right.left.key, right.left.value, new KVTree<K, V>(right.left.right, right.key, right.value, right.right));
            }
            return KVTree.join(KVTree.join(left, key, value, right.left), right.key, right.value, right.right);
        }
        if (left.height == right.height + 2 && left.right.height > left.left.height) {
            return new KVTree<K, V>(new KVTree<K, V>(left.left, left.key, left.value, left.right.left), left.right.key, left.right.value, new KVTree<K, V>(left.right.right, key, value, right));
        }
        return KVTree.join(left.left, left.key, left.value, KVTree.join(left.right, key, value, right));
    }

    static <K, V> KVTree<K, V> empty() {
        return EMPTY;
    }

    static <K, V> KVTree<K, V> fromEntryIterator(Iterator<? extends Map.Entry<? extends K, ? extends V>> iterator) {
        return KVTree.fromIterator(iterator, IteratorType.ENTRY, Integer.MAX_VALUE);
    }

    static <K, V> KVTree<K, V> fromKeyIterator(Iterator<? extends K> iterator) {
        return KVTree.fromIterator(iterator, IteratorType.KEY, Integer.MAX_VALUE);
    }

    private static <K, V> KVTree<K, V> fromIterator(Iterator<?> iterator, IteratorType iteratorType, int maxHeight) {
        KVTree<K, V> left;
        KVTree<K, V> right;
        KVTree<K, Object> curr = KVTree.empty();
        do {
            if (curr.height >= maxHeight) {
                assert (curr.height == maxHeight);
                return curr;
            }
            if (!iterator.hasNext()) {
                return curr;
            }
            left = curr;
            Object datum = iterator.next();
            Object key = iteratorType == IteratorType.KEY ? datum : ((Map.Entry)datum).getKey();
            V value = iteratorType == IteratorType.KEY ? null : (V)((Map.Entry)datum).getValue();
            right = KVTree.fromIterator(iterator, iteratorType, left.height);
            curr = KVTree.join(left, key, value, right);
        } while (right.height >= left.height);
        return curr;
    }

    Iterator<Map.Entry<K, V>> entryIterator(boolean isLeftToRight) {
        return new EntryIterator(this, isLeftToRight);
    }

    @Override
    public boolean equals(Object o) {
        Map.Entry that = o instanceof Map.Entry ? (Map.Entry)o : null;
        return that != null && Objects.equals(this.key, that.getKey()) && Objects.equals(this.value, that.getValue());
    }

    @Override
    public K getKey() {
        return this.key;
    }

    KVTree<K, V> getLeftmost() {
        this.checkNotEmpty();
        KVTree<K, V> currNode = this;
        while (!currNode.left.isEmpty()) {
            currNode = currNode.left;
        }
        return currNode;
    }

    KVTree<K, V> getRightmost() {
        this.checkNotEmpty();
        KVTree<K, V> currNode = this;
        while (!currNode.right.isEmpty()) {
            currNode = currNode.right;
        }
        return currNode;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
    }

    boolean isEmpty() {
        return this == EMPTY;
    }

    KVTree<K, V> minus(K key, Comparator<? super K> comparator) {
        if (this.isEmpty()) {
            return this;
        }
        int cmp = comparator.compare(key, this.key);
        if (cmp < 0) {
            return this.replaceLeft(this.left.minus(key, comparator));
        }
        if (cmp == 0) {
            return KVTree.concat(this.left, this.right);
        }
        return this.replaceRight(this.right.minus(key, comparator));
    }

    KVTree<K, V> minusLeftmost() {
        this.checkNotEmpty();
        if (this.left.isEmpty()) {
            return this.right;
        }
        return KVTree.join(this.left.minusLeftmost(), this.key, this.value, this.right);
    }

    KVTree<K, V> minusRightmost() {
        this.checkNotEmpty();
        if (this.right.isEmpty()) {
            return this.left;
        }
        return KVTree.join(this.left, this.key, this.value, this.right.minusRightmost());
    }

    Map.Entry<K, V> orNullIfEmpty() {
        return this == EMPTY ? null : this;
    }

    KVTree<K, V> plus(K key, V value, Comparator<? super K> comparator) {
        if (this.isEmpty()) {
            return KVTree.join(KVTree.empty(), key, value, KVTree.empty());
        }
        int cmp = comparator.compare(key, this.key);
        if (cmp < 0) {
            return this.replaceLeft(this.left.plus(key, value, comparator));
        }
        if (cmp == 0) {
            return this.replaceValue(value);
        }
        return this.replaceRight(this.right.plus(key, value, comparator));
    }

    KVTree<K, V> range(K leftBound, boolean isLeftBoundInclusive, K rightBound, boolean isRightBoundInclusive, Comparator<? super K> comparator) {
        int fromCmp;
        if (this.isEmpty()) {
            return this;
        }
        int toCmp = comparator.compare(rightBound, this.key);
        int n = fromCmp = toCmp < 0 ? -1 : comparator.compare(leftBound, this.key);
        if (toCmp < 0) {
            return this.left.range(leftBound, isLeftBoundInclusive, rightBound, isRightBoundInclusive, comparator);
        }
        if (toCmp == 0) {
            if (fromCmp == 0) {
                if (isLeftBoundInclusive && isRightBoundInclusive) {
                    return KVTree.join(KVTree.empty(), this.key, this.value, KVTree.empty());
                }
                return KVTree.empty();
            }
            KVTree<? super K, V> left = this.left.rangeToRight(leftBound, isLeftBoundInclusive, comparator);
            if (isRightBoundInclusive) {
                return KVTree.join(left, this.key, this.value, KVTree.empty());
            }
            return left;
        }
        if (fromCmp < 0) {
            return KVTree.join(this.left.rangeToRight(leftBound, isLeftBoundInclusive, comparator), this.key, this.value, this.right.rangeToLeft(rightBound, isRightBoundInclusive, comparator));
        }
        if (fromCmp == 0) {
            KVTree<? super K, V> right = this.right.rangeToLeft(rightBound, isRightBoundInclusive, comparator);
            if (isLeftBoundInclusive) {
                return KVTree.join(KVTree.empty(), this.key, this.value, right);
            }
            return right;
        }
        return this.right.range(leftBound, isLeftBoundInclusive, rightBound, isRightBoundInclusive, comparator);
    }

    KVTree<K, V> rangeToLeft(K rightBound, boolean isRightBoundInclusive, Comparator<? super K> comparator) {
        if (this.isEmpty()) {
            return this;
        }
        int cmp = comparator.compare(rightBound, this.key);
        if (cmp < 0) {
            return this.left.rangeToLeft(rightBound, isRightBoundInclusive, comparator);
        }
        if (cmp == 0) {
            if (isRightBoundInclusive) {
                return KVTree.join(this.left, this.key, this.value, KVTree.empty());
            }
            return this.left;
        }
        return this.replaceRight(this.right.rangeToLeft(rightBound, isRightBoundInclusive, comparator));
    }

    KVTree<K, V> rangeToRight(K leftBound, boolean isleftBoundInclusive, Comparator<? super K> comparator) {
        if (this.isEmpty()) {
            return this;
        }
        int cmp = comparator.compare(leftBound, this.key);
        if (cmp < 0) {
            return this.replaceLeft(this.left.rangeToRight(leftBound, isleftBoundInclusive, comparator));
        }
        if (cmp == 0) {
            if (isleftBoundInclusive) {
                return KVTree.join(KVTree.empty(), this.key, this.value, this.right);
            }
            return this.right;
        }
        return this.right.rangeToRight(leftBound, isleftBoundInclusive, comparator);
    }

    KVTree<K, V> search(K key, Comparator<? super K> comparator, SearchType searchType) {
        KVTree<K, V> currNode = this;
        KVTree<K, V> candidate = KVTree.empty();
        while (!currNode.isEmpty()) {
            int cmp = comparator.compare(key, currNode.key);
            if (cmp < 0) {
                if (searchType == SearchType.GE || searchType == SearchType.GT) {
                    candidate = currNode;
                }
                currNode = currNode.left;
                continue;
            }
            if (cmp == 0) {
                if (searchType == SearchType.LT) {
                    if (currNode.left.isEmpty()) {
                        return candidate;
                    }
                    return currNode.left.getRightmost();
                }
                if (searchType == SearchType.LE || searchType == SearchType.EQ || searchType == SearchType.GE) {
                    return currNode;
                }
                if (currNode.right.isEmpty()) {
                    return candidate;
                }
                return currNode.right.getLeftmost();
            }
            if (searchType == SearchType.LT || searchType == SearchType.LE) {
                candidate = currNode;
            }
            currNode = currNode.right;
        }
        return candidate;
    }

    @Override
    @Deprecated
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    int size() {
        return this.size;
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    private Object readResolve() {
        if (this.size == 0) {
            return EMPTY;
        }
        return this;
    }

    private void checkNotEmpty() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
    }

    private KVTree<K, V> replaceLeft(KVTree<K, V> newLeft) {
        return this.left == newLeft ? this : KVTree.join(newLeft, this.key, this.value, this.right);
    }

    private KVTree<K, V> replaceRight(KVTree<K, V> newRight) {
        return this.right == newRight ? this : KVTree.join(this.left, this.key, this.value, newRight);
    }

    private KVTree<K, V> replaceValue(V newValue) {
        return this.value == newValue ? this : KVTree.join(this.left, this.key, newValue, this.right);
    }

    private static <K, V> KVTree<K, V> concat(KVTree<K, V> left, KVTree<K, V> right) {
        if (right.isEmpty()) {
            return left;
        }
        KVTree<K, V> mid = right.getLeftmost();
        KVTree<K, V> restOfRight = right.minusLeftmost();
        return KVTree.join(left, mid.key, mid.value, restOfRight);
    }

    private static enum IteratorType {
        ENTRY,
        KEY;

    }

    private static class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final boolean isLeftToRight;
        private KVTree<K, V> nextSubtree;
        private final ArrayList<KVTree<K, V>> stack = new ArrayList();

        EntryIterator(KVTree<K, V> tree, boolean isLeftToRight) {
            this.isLeftToRight = isLeftToRight;
            this.nextSubtree = tree;
        }

        @Override
        public boolean hasNext() {
            return ((KVTree)this.nextSubtree).size > 0 || this.stack.size() > 0;
        }

        @Override
        public Map.Entry<K, V> next() {
            while (((KVTree)this.nextSubtree).size > 0) {
                this.stack.add(this.nextSubtree);
                this.nextSubtree = this.firstChild(this.nextSubtree);
            }
            if (this.stack.isEmpty()) {
                throw new NoSuchElementException();
            }
            KVTree<K, V> result = this.stack.remove(this.stack.size() - 1);
            this.nextSubtree = this.secondChild(result);
            return result;
        }

        private KVTree<K, V> firstChild(KVTree<K, V> node) {
            return this.isLeftToRight ? ((KVTree)node).left : ((KVTree)node).right;
        }

        private KVTree<K, V> secondChild(KVTree<K, V> node) {
            return this.isLeftToRight ? ((KVTree)node).right : ((KVTree)node).left;
        }
    }

    static enum SearchType {
        LT,
        LE,
        EQ,
        GE,
        GT;

    }
}

