/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jsampler.HF;
import org.jsampler.JSI18n;
import org.jsampler.Prefs;
import org.jsampler.view.classic.Channel;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.ClassicPrefs;
import org.jsampler.view.std.JSColorButton;

class ViewPane
extends JPanel {
    private final JLabel lIfaceLanguage = new JLabel(ClassicI18n.i18n.getLabel("ViewPane.lIfaceLanguage"));
    private final JComboBox cbIfaceLanguage = new JComboBox();
    private final JLabel lIfaceFont = new JLabel(ClassicI18n.i18n.getLabel("ViewPane.lIfaceFont"));
    private final JComboBox cbIfaceFont = new JComboBox();
    private final JCheckBox checkBorderColor = new JCheckBox(ClassicI18n.i18n.getLabel("ViewPane.channelBorderColor"));
    private final JSColorButton btnBorderColor = new JSColorButton(Color.WHITE);
    private final JCheckBox checkHlChnBorderColor = new JCheckBox(ClassicI18n.i18n.getLabel("ViewPane.checkHlChnBorderColor"));
    private final JSColorButton btnHlChnBorderColor = new JSColorButton(Color.WHITE);
    private final JCheckBox checkSelChnBgColor = new JCheckBox(ClassicI18n.i18n.getLabel("ViewPane.checkSelChnBgColor"));
    private final JSColorButton btnSelChnBgColor = new JSColorButton(Color.WHITE);
    private final JCheckBox checkHlChnBgColor = new JCheckBox(ClassicI18n.i18n.getLabel("ViewPane.checkHlChnBgColor"));
    private final JSColorButton btnHlChnBgColor = new JSColorButton(Color.WHITE);

    public ViewPane() {
        this.initViewPane();
    }

    private void initViewPane() {
        this.cbIfaceLanguage.setMaximumSize(new Dimension(Short.MAX_VALUE, this.cbIfaceLanguage.getPreferredSize().height));
        for (Locale locale : JSI18n.getAvailableLocales()) {
            Object object = new LocaleBox(locale);
            this.cbIfaceLanguage.addItem(object);
            if (!locale.getLanguage().equals(Prefs.getInterfaceLanguage()) || !locale.getCountry().equals(Prefs.getInterfaceCountry())) continue;
            this.cbIfaceLanguage.setSelectedItem(object);
        }
        this.cbIfaceFont.setMaximumSize(new Dimension(Short.MAX_VALUE, this.cbIfaceFont.getPreferredSize().height));
        this.cbIfaceFont.addItem("[Default]");
        Object[] objectArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (Object object : objectArray) {
            this.cbIfaceFont.addItem(object);
        }
        if (Prefs.getInterfaceFont() == null) {
            this.cbIfaceFont.setSelectedItem("[Default]");
        } else {
            this.cbIfaceFont.setSelectedItem(Prefs.getInterfaceFont());
        }
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.lIfaceLanguage);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.cbIfaceLanguage);
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.lIfaceFont);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.cbIfaceFont);
        this.add(jPanel2);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        this.add(this.createCustomColorsPane());
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
    }

    private JPanel createCustomColorsPane() {
        this.btnBorderColor.setColor(ClassicPrefs.getChannelBorderColor());
        this.btnBorderColor.setEnabled(ClassicPrefs.getCustomChannelBorderColor());
        this.checkBorderColor.setSelected(ClassicPrefs.getCustomChannelBorderColor());
        this.checkBorderColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                ViewPane.this.btnBorderColor.setEnabled(bl);
            }
        });
        this.btnHlChnBorderColor.setColor(ClassicPrefs.getChannelBorderHlColor());
        this.btnHlChnBorderColor.setEnabled(ClassicPrefs.getCustomChannelBorderHlColor());
        this.checkHlChnBorderColor.setSelected(ClassicPrefs.getCustomChannelBorderHlColor());
        this.checkHlChnBorderColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                ViewPane.this.btnHlChnBorderColor.setEnabled(bl);
            }
        });
        Color color = ClassicPrefs.getSelectedChannelBgColor();
        if (color == null) {
            color = new Color(this.getBackground().getRGB());
        }
        this.btnSelChnBgColor.setColor(color);
        this.btnSelChnBgColor.setEnabled(ClassicPrefs.getCustomSelectedChannelBgColor());
        this.checkSelChnBgColor.setSelected(ClassicPrefs.getCustomSelectedChannelBgColor());
        this.checkSelChnBgColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                ViewPane.this.btnSelChnBgColor.setEnabled(bl);
            }
        });
        color = ClassicPrefs.getHighlightedChannelBgColor();
        if (color == null) {
            color = new Color(this.getBackground().getRGB());
        }
        this.btnHlChnBgColor.setColor(color);
        this.btnHlChnBgColor.setEnabled(ClassicPrefs.getCustomHighlightedChannelBgColor());
        this.checkHlChnBgColor.setSelected(ClassicPrefs.getCustomHighlightedChannelBgColor());
        this.checkHlChnBgColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                ViewPane.this.btnHlChnBgColor.setEnabled(bl);
            }
        });
        JButton jButton = new JButton("Reset to defaults");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassicPrefs.setChannelBorderColor(null);
                ViewPane.this.btnBorderColor.setColor(ClassicPrefs.getChannelBorderColor());
                ClassicPrefs.setChannelBorderHlColor(null);
                ViewPane.this.btnHlChnBorderColor.setColor(ClassicPrefs.getChannelBorderHlColor());
                ClassicPrefs.setSelectedChannelBgColor(null);
                ViewPane.this.btnSelChnBgColor.setColor(ClassicPrefs.getSelectedChannelBgColor());
                ClassicPrefs.setHighlightedChannelBgColor(null);
                ViewPane.this.btnHlChnBgColor.setColor(ClassicPrefs.getHighlightedChannelBgColor());
            }
        });
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        gridBagLayout.setConstraints(this.checkBorderColor, gridBagConstraints);
        jPanel.add(this.checkBorderColor);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.btnBorderColor, gridBagConstraints);
        jPanel.add(this.btnBorderColor);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.checkHlChnBorderColor, gridBagConstraints);
        jPanel.add(this.checkHlChnBorderColor);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.btnHlChnBorderColor, gridBagConstraints);
        jPanel.add(this.btnHlChnBorderColor);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.checkSelChnBgColor, gridBagConstraints);
        jPanel.add(this.checkSelChnBgColor);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.btnSelChnBgColor, gridBagConstraints);
        jPanel.add(this.btnSelChnBgColor);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.checkHlChnBgColor, gridBagConstraints);
        jPanel.add(this.checkHlChnBgColor);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.btnHlChnBgColor, gridBagConstraints);
        jPanel.add(this.btnHlChnBgColor);
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 0, 6, 6));
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel2.add(Box.createGlue());
        jPanel2.add(jButton);
        jPanel2.add(Box.createGlue());
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel.setBorder(BorderFactory.createTitledBorder(ClassicI18n.i18n.getLabel("ViewPane.CustomColorsPane")));
        jPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, jPanel.getPreferredSize().height));
        return jPanel;
    }

    private String getInterfaceLanguage() {
        LocaleBox localeBox = (LocaleBox)this.cbIfaceLanguage.getSelectedItem();
        if (localeBox == null) {
            return null;
        }
        return localeBox.getLocale().getLanguage();
    }

    private String getInterfaceCountry() {
        LocaleBox localeBox = (LocaleBox)this.cbIfaceLanguage.getSelectedItem();
        if (localeBox == null) {
            return null;
        }
        return localeBox.getLocale().getCountry();
    }

    private String getInterfaceFontName() {
        return this.cbIfaceFont.getSelectedItem().toString();
    }

    protected void apply() {
        boolean bl = Prefs.setInterfaceLanguage(this.getInterfaceLanguage());
        boolean bl2 = Prefs.setInterfaceCountry(this.getInterfaceCountry());
        if (bl || bl2) {
            JOptionPane.showMessageDialog(this, ClassicI18n.i18n.getMessage("PrefsDlg.ifaceChangeInfo", "JS Classic"), null, 1);
        }
        bl = false;
        String string = this.getInterfaceFontName();
        if (string.equals("[Default]")) {
            bl = Prefs.setInterfaceFont(null);
        } else if (Prefs.setInterfaceFont(string)) {
            HF.setUIDefaultFont(string);
            bl = true;
        }
        if (bl) {
            JOptionPane.showMessageDialog(this, ClassicI18n.i18n.getMessage("PrefsDlg.ifaceFontChangeInfo", "JS Classic"), null, 1);
        }
        bl = this.checkBorderColor.isSelected();
        ClassicPrefs.setCustomChannelBorderColor(bl);
        if (bl) {
            ClassicPrefs.setChannelBorderColor(this.btnBorderColor.getColor());
        }
        Color color = bl ? ClassicPrefs.getChannelBorderColor() : ClassicPrefs.getDefaultChannelBorderColor();
        Channel.setBorderColor(color);
        bl = this.checkHlChnBorderColor.isSelected();
        ClassicPrefs.setCustomChannelBorderHlColor(bl);
        if (bl) {
            ClassicPrefs.setChannelBorderHlColor(this.btnHlChnBorderColor.getColor());
        }
        color = bl ? ClassicPrefs.getChannelBorderHlColor() : ClassicPrefs.getDefaultChannelBorderHlColor();
        Channel.setBorderHighlightedColor(color);
        bl = this.checkSelChnBgColor.isSelected();
        ClassicPrefs.setCustomSelectedChannelBgColor(bl);
        if (bl) {
            ClassicPrefs.setSelectedChannelBgColor(this.btnSelChnBgColor.getColor());
        }
        if ((color = bl ? ClassicPrefs.getSelectedChannelBgColor() : new Color(this.getBackground().getRGB())) == null) {
            color = new Color(this.getBackground().getRGB());
        }
        Channel.setSelectedChannelBgColor(color);
        bl = this.checkHlChnBgColor.isSelected();
        ClassicPrefs.setCustomHighlightedChannelBgColor(bl);
        if (bl) {
            ClassicPrefs.setHighlightedChannelBgColor(this.btnHlChnBgColor.getColor());
        }
        if ((color = bl ? ClassicPrefs.getHighlightedChannelBgColor() : new Color(this.getBackground().getRGB())) == null) {
            color = new Color(this.getBackground().getRGB());
        }
        Channel.setHighlightedChannelBgColor(color);
    }

    class LocaleBox {
        private Locale locale;

        LocaleBox(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String toString() {
            return this.locale.getDisplayLanguage(JSI18n.i18n.getCurrentLocale());
        }
    }
}

