/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.juife.InformationDialog;
import net.sf.juife.LinkButton;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.License;
import org.jsampler.view.classic.LicenseDlg;
import org.jsampler.view.classic.WebButton;

class LibraryInfoDlg
extends InformationDialog {
    private JLabel lAuthor = new JLabel(ClassicI18n.i18n.getLabel("LibraryInfoDlg.lAuthor"));
    private JTextField tfAuthor = new JTextField(ClassicI18n.i18n.getLabel("LibraryInfoDlg.tfAuthor"));
    private JLabel lLicense = new JLabel(ClassicI18n.i18n.getLabel("LibraryInfoDlg.lLicense"));
    private LinkButton btnLicense = new LinkButton(" ");
    private JLabel lWebsite = new JLabel(ClassicI18n.i18n.getLabel("LibraryInfoDlg.lWebsite"));
    private WebButton btnWebsite = new WebButton("");

    LibraryInfoDlg(Dialog dialog, String string, String string2, String string3, final License license) {
        super(dialog, string);
        switch (license) {
            case GPL: {
                this.btnLicense.setText("GNU General Public License");
                break;
            }
            case LGPL: {
                this.btnLicense.setText("GNU Lesser General Public License");
            }
        }
        this.btnWebsite.setText(string3);
        this.setMainPane(new LibraryInfoPane(string, string2, license));
        this.btnLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryInfoDlg.this.showLicense(license);
            }
        });
    }

    private void showLicense(License license) {
        new LicenseDlg((Dialog)this, license).setVisible(true);
    }

    class LibraryInfoPane
    extends JPanel {
        private JLabel lProductName;

        LibraryInfoPane(String string, String string2, License license) {
            this.lProductName = new JLabel("<html>\n<font size=+1>" + string + " (version " + string2 + ")</font>");
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 6);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(LibraryInfoDlg.this.lAuthor, gridBagConstraints);
            this.add(LibraryInfoDlg.this.lAuthor);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(LibraryInfoDlg.this.lLicense, gridBagConstraints);
            this.add(LibraryInfoDlg.this.lLicense);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.insets = new Insets(12, 0, 0, 6);
            gridBagLayout.setConstraints(LibraryInfoDlg.this.lWebsite, gridBagConstraints);
            this.add(LibraryInfoDlg.this.lWebsite);
            LibraryInfoDlg.this.tfAuthor.setEditable(false);
            LibraryInfoDlg.this.tfAuthor.setBorder(BorderFactory.createEmptyBorder());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(LibraryInfoDlg.this.tfAuthor, gridBagConstraints);
            this.add(LibraryInfoDlg.this.tfAuthor);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(LibraryInfoDlg.this.btnLicense, gridBagConstraints);
            this.add(LibraryInfoDlg.this.btnLicense);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.insets = new Insets(12, 0, 0, 0);
            gridBagLayout.setConstraints(LibraryInfoDlg.this.btnWebsite, gridBagConstraints);
            this.add(LibraryInfoDlg.this.btnWebsite);
            this.lProductName.setHorizontalAlignment(0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(0, 0, 12, 0);
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.lProductName, gridBagConstraints);
            this.add(this.lProductName);
        }
    }
}

