/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.Parseable;
import org.linuxsampler.lscp.Parser;
import org.linuxsampler.lscp.SamplerEngine;

public class SamplerChannel
implements Parseable {
    private static final int MUTED_BY_SOLO = -1;
    private int chnId = -1;
    private SamplerEngine engine = null;
    private int aoDevice = -1;
    private int aoChannels = 0;
    private Integer[] aor = null;
    private String instrFile = null;
    private int instrIdx = 0;
    private String instrName = null;
    private int instrStat = 0;
    private int miDev = -1;
    private int miPort = 0;
    private int miChn = -1;
    private float vol = 0.0f;
    private int mute = 0;
    private boolean solo = false;
    private int midiInstrumentMapId = -1;

    public SamplerChannel() {
    }

    public SamplerChannel(String[] stringArray) throws LscpException {
        for (String string : stringArray) {
            if (this.parse(string)) continue;
            Client.getLogger().info(LscpI18n.getLogMsg("unknownLine", string));
        }
    }

    public int getChannelId() {
        return this.chnId;
    }

    public void setChannelId(int n) {
        this.chnId = n;
    }

    public SamplerEngine getEngine() {
        return this.engine;
    }

    public void setEngine(SamplerEngine samplerEngine) {
        this.engine = samplerEngine;
    }

    public int getAudioOutputDevice() {
        return this.aoDevice;
    }

    public int getAudioOutputChannels() {
        return this.aoChannels;
    }

    public Integer[] getAudioOutputRouting() {
        return this.aor;
    }

    public String getInstrumentFile() {
        return this.instrFile;
    }

    public int getInstrumentIndex() {
        return this.instrIdx;
    }

    public String getInstrumentName() {
        return this.instrName;
    }

    public int getInstrumentStatus() {
        return this.instrStat;
    }

    public int getMidiInputDevice() {
        return this.miDev;
    }

    public int getMidiInputPort() {
        return this.miPort;
    }

    public int getMidiInputChannel() {
        return this.miChn;
    }

    public float getVolume() {
        return this.vol;
    }

    public boolean isMuted() {
        return this.mute != 0;
    }

    public boolean isMutedBySolo() {
        return this.mute == -1;
    }

    public boolean isSoloChannel() {
        return this.solo;
    }

    public int getMidiInstrumentMapId() {
        return this.midiInstrumentMapId;
    }

    public boolean isUsingDefaultMidiInstrumentMap() {
        return this.getMidiInstrumentMapId() == -2;
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (string.startsWith("ENGINE_NAME: ")) {
            if ((string = string.substring("ENGINE_NAME: ".length())).equals("NONE")) {
                this.engine = null;
            } else {
                this.engine = new SamplerEngine();
                this.engine.setName(string);
            }
        } else if (string.startsWith("AUDIO_OUTPUT_DEVICE: ")) {
            this.aoDevice = (string = string.substring("AUDIO_OUTPUT_DEVICE: ".length())).equals("NONE") ? -1 : Parser.parseInt(string);
        } else if (string.startsWith("AUDIO_OUTPUT_CHANNELS: ")) {
            this.aoChannels = (string = string.substring("AUDIO_OUTPUT_CHANNELS: ".length())).equals("NONE") ? -1 : Parser.parseInt(string);
        } else if (string.startsWith("AUDIO_OUTPUT_ROUTING: ")) {
            string = string.substring("AUDIO_OUTPUT_ROUTING: ".length());
            this.aor = Parser.parseIntList(string);
        } else if (string.startsWith("INSTRUMENT_FILE: ")) {
            this.instrFile = (string = string.substring("INSTRUMENT_FILE: ".length())).equals("NONE") ? null : string;
        } else if (string.startsWith("INSTRUMENT_NR: ")) {
            this.instrIdx = (string = string.substring("INSTRUMENT_NR: ".length())).equals("NONE") ? -1 : Parser.parseInt(string);
        } else if (string.startsWith("INSTRUMENT_NAME: ")) {
            this.instrName = (string = string.substring("INSTRUMENT_NAME: ".length())).equals("NONE") ? null : Parser.toNonEscapedString(string);
        } else if (string.startsWith("INSTRUMENT_STATUS: ")) {
            string = string.substring("INSTRUMENT_STATUS: ".length());
            this.instrStat = Parser.parseInt(string);
        } else if (string.startsWith("MIDI_INPUT_DEVICE: ")) {
            this.miDev = (string = string.substring("MIDI_INPUT_DEVICE: ".length())).equals("NONE") ? -1 : Parser.parseInt(string);
        } else if (string.startsWith("MIDI_INPUT_PORT: ")) {
            this.miPort = (string = string.substring("MIDI_INPUT_PORT: ".length())).equals("NONE") ? -1 : Parser.parseInt(string);
        } else if (string.startsWith("MIDI_INPUT_CHANNEL: ")) {
            this.miChn = (string = string.substring("MIDI_INPUT_CHANNEL: ".length())).equals("ALL") ? -1 : Parser.parseInt(string);
        } else if (string.startsWith("VOLUME: ")) {
            string = string.substring("VOLUME: ".length());
            try {
                this.vol = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"), numberFormatException);
            }
        } else if (string.startsWith("MUTE: ")) {
            this.mute = (string = string.substring("MUTE: ".length())).equals("MUTED_BY_SOLO") ? -1 : (Boolean.parseBoolean(string) ? 1 : 0);
        } else if (string.startsWith("SOLO: ")) {
            string = string.substring("SOLO: ".length());
            this.solo = Boolean.parseBoolean(string);
        } else if (string.startsWith("MIDI_INSTRUMENT_MAP: ")) {
            this.midiInstrumentMapId = (string = string.substring("MIDI_INSTRUMENT_MAP: ".length())).equals("NONE") ? -1 : (string.equals("DEFAULT") ? -2 : Parser.parseInt(string));
        } else {
            return false;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getChannelId());
    }
}

