/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.digest.BubbleBabble;
import org.jruby.runtime.Block;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyModule(name={"Digest"})
public class RubyDigest {
    private static final Map<String, MessageDigest> CLONEABLE_DIGESTS = new HashMap<String, MessageDigest>(8, 1.0f);
    private static final String PROVIDER = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static Provider provider;
    private static final byte[] digits;

    private static MessageDigest getCloneableMessageDigestInstance(String name2) {
        try {
            MessageDigest digest2 = MessageDigest.getInstance(name2);
            digest2.clone();
            return digest2;
        }
        catch (NoSuchAlgorithmException e) {
            RubyDigest.logger().warn("digest '" + name2 + "' not supported", e);
        }
        catch (Exception e) {
            RubyDigest.logger().debug("digest '" + name2 + "' not cloneable", e);
        }
        return null;
    }

    private static Logger logger() {
        return LoggerFactory.getLogger(RubyDigest.class);
    }

    public static void createDigest(ThreadContext context) {
        try {
            provider = (Provider)Class.forName(PROVIDER).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Object Digest = Define.defineModule(context, "Digest").defineMethods(context, RubyDigest.class);
        Object DigestInstance2 = ((RubyModule)Digest).defineModuleUnder(context, "Instance").defineMethods(context, DigestInstance.class);
        RubyClass DigestClass2 = (RubyClass)((RubyModule)((RubyModule)((RubyModule)Digest).defineClassUnder(context, "Class", Access.objectClass(context), DigestClass::new)).include(context, (RubyModule)DigestInstance2)).defineMethods(context, DigestClass.class);
        ((RubyModule)((RubyModule)Digest).defineClassUnder(context, "Base", DigestClass2, DigestBase::new)).defineMethods(context, DigestBase.class);
    }

    private static MessageDigest createMessageDigest(String name2) throws NoSuchAlgorithmException {
        MessageDigest cloneable = CLONEABLE_DIGESTS.get(name2);
        if (cloneable != null) {
            try {
                return (MessageDigest)cloneable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        if (provider != null) {
            try {
                return MessageDigest.getInstance(name2, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return MessageDigest.getInstance(name2);
    }

    private static ByteList toHex(byte[] val) {
        ByteList byteList = new ByteList(val.length * 2);
        for (byte value2 : val) {
            int b2 = value2 & 0xFF;
            byteList.append(digits[b2 >> 4]);
            byteList.append(digits[b2 & 0xF]);
        }
        return byteList;
    }

    private static RubyString toHexString(ThreadContext context, byte[] val) {
        return RubyString.newStringNoCopy(context.runtime, new ByteList(ByteList.plain(RubyDigest.toHex(val)), (Encoding)USASCIIEncoding.INSTANCE));
    }

    @Deprecated(since="10.0")
    public static RubyString hexencode(IRubyObject self2, IRubyObject arg2) {
        return RubyDigest.hexencode(((RubyBasicObject)self2).getCurrentContext(), self2, arg2);
    }

    @JRubyMethod(name={"hexencode"}, meta=true)
    public static RubyString hexencode(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        return RubyDigest.toHexString(context, arg2.convertToString().getBytes());
    }

    @Deprecated(since="10.0")
    public static RubyString bubblebabble(IRubyObject recv2, IRubyObject arg2) {
        return RubyDigest.bubblebabble(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg2);
    }

    @JRubyMethod(name={"bubblebabble"}, meta=true)
    public static RubyString bubblebabble(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        ByteList bytes2 = arg2.convertToString().getByteList();
        return Create.newString(context, BubbleBabble.bubblebabble(bytes2.unsafeBytes(), bytes2.begin(), bytes2.length()));
    }

    public static void createDigestMD5(ThreadContext context) {
        Access.loadService(context).require("digest");
        RubyModule Digest = Access.getModule(context, "Digest");
        RubyClass Base = Digest.getClass(context, "Base");
        Object MD52 = Digest.defineClassUnder(context, "MD5", Base, Base.getAllocator());
        ((RubyBasicObject)MD52).setInternalVariable("metadata", new Metadata("MD5", 64));
    }

    public static void createDigestRMD160(ThreadContext context) {
        Access.loadService(context).require("digest");
        if (provider == null) {
            throw context.runtime.newLoadError("RMD160 not supported without BouncyCastle");
        }
        RubyModule Digest = Access.getModule(context, "Digest");
        RubyClass Base = Digest.getClass(context, "Base");
        Object RMD1602 = Digest.defineClassUnder(context, "RMD160", Base, Base.getAllocator());
        ((RubyBasicObject)RMD1602).setInternalVariable("metadata", new Metadata("RIPEMD160", 64));
    }

    public static void createDigestSHA1(ThreadContext context) {
        Access.loadService(context).require("digest");
        RubyModule Digest = Access.getModule(context, "Digest");
        RubyClass Base = Digest.getClass(context, "Base");
        Object SHA12 = Digest.defineClassUnder(context, "SHA1", Base, Base.getAllocator());
        ((RubyBasicObject)SHA12).setInternalVariable("metadata", new Metadata("SHA1", 64));
    }

    public static void createDigestSHA2(ThreadContext context) {
        Access.loadService(context).require("digest");
        try {
            RubyDigest.createMessageDigest("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            RaiseException ex = context.runtime.newLoadError("SHA2 not supported");
            ex.initCause(e);
            throw ex;
        }
        RubyModule Digest = Access.getModule(context, "Digest");
        RubyClass Base = Digest.getClass(context, "Base");
        Object SHA2562 = Digest.defineClassUnder(context, "SHA256", Base, Base.getAllocator());
        ((RubyBasicObject)SHA2562).setInternalVariable("metadata", new Metadata("SHA-256", 64));
        Object SHA3842 = Digest.defineClassUnder(context, "SHA384", Base, Base.getAllocator());
        ((RubyBasicObject)SHA3842).setInternalVariable("metadata", new Metadata("SHA-384", 128));
        Object SHA5122 = Digest.defineClassUnder(context, "SHA512", Base, Base.getAllocator());
        ((RubyBasicObject)SHA5122).setInternalVariable("metadata", new Metadata("SHA-512", 128));
    }

    public static void createDigestBubbleBabble(ThreadContext context) {
        Access.loadService(context).require("digest");
        RubyModule Digest = Access.getModule(context, "Digest");
        RubyClass Base = Digest.getClass(context, "Base");
        Object MD52 = Digest.defineClassUnder(context, "BubbleBabble", Base, Base.getAllocator());
        ((RubyBasicObject)MD52).setInternalVariable("metadata", new Metadata("BubbleBabble", 64));
    }

    private static JavaSites.DigestSites sites(ThreadContext context) {
        return context.sites.Digest;
    }

    static {
        for (String name2 : new String[]{"MD2", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"}) {
            MessageDigest digest2 = RubyDigest.getCloneableMessageDigestInstance(name2);
            if (digest2 == null) continue;
            CLONEABLE_DIGESTS.put(name2, digest2);
        }
        provider = null;
        digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    }

    @JRubyModule(name={"Digest::Instance"})
    public static class DigestInstance {
        private static IRubyObject throwUnimplError(ThreadContext context, IRubyObject self2, String name2) {
            throw Error.runtimeError(context, String.format("%s does not implement %s()", self2.getMetaClass().getRealClass().getName(context), name2));
        }

        @JRubyMethod(name={"update", "<<"})
        public static IRubyObject update(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            return DigestInstance.throwUnimplError(context, self2, "update");
        }

        @JRubyMethod
        public static IRubyObject finish(ThreadContext context, IRubyObject self2) {
            return DigestInstance.throwUnimplError(context, self2, "finish");
        }

        @JRubyMethod
        public static IRubyObject reset(ThreadContext context, IRubyObject self2) {
            return DigestInstance.throwUnimplError(context, self2, "reset");
        }

        @JRubyMethod
        public static IRubyObject digest_length(ThreadContext context, IRubyObject self2) {
            return DigestInstance.digest(context, self2, IRubyObject.NULL_ARRAY).convertToString().bytesize(context);
        }

        @JRubyMethod
        public static IRubyObject block_length(ThreadContext context, IRubyObject self2) {
            return DigestInstance.throwUnimplError(context, self2, "block_length");
        }

        @JRubyMethod(name={"=="})
        public static IRubyObject op_equal(ThreadContext context, IRubyObject self2, IRubyObject oth) {
            RubyString str2;
            RubyString str1;
            if (oth.isNil()) {
                return context.fals;
            }
            RubyModule instance = Access.getModule(context, "Digest").getModule(context, "Instance");
            if (oth.getMetaClass().getRealClass().hasModuleInHierarchy(instance)) {
                str1 = DigestInstance.digest(context, self2, IRubyObject.NULL_ARRAY).convertToString();
                str2 = DigestInstance.digest(context, oth, IRubyObject.NULL_ARRAY).convertToString();
            } else {
                str1 = DigestInstance.to_s(context, self2).convertToString();
                str2 = oth.convertToString();
            }
            boolean ret = str1.bytesize(context).eql(str2.bytesize(context)) && str1.eql(str2);
            return ret ? context.tru : context.fals;
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            return RubyString.newStringNoCopy(context.runtime, ByteList.plain("#<" + self2.getMetaClass().getRealClass().getName(context) + ": " + String.valueOf(DigestInstance.hexdigest(context, self2, IRubyObject.NULL_ARRAY)) + ">"));
        }

        @JRubyMethod(name={"new"})
        public static IRubyObject newObject(ThreadContext context, IRubyObject self2) {
            return self2.rbClone().callMethod(context, "reset");
        }

        @JRubyMethod
        public static IRubyObject digest(ThreadContext context, IRubyObject self2) {
            return DigestInstance.digest_bang(context, self2.rbClone());
        }

        @JRubyMethod
        public static IRubyObject digest(ThreadContext context, IRubyObject self2, IRubyObject arg0) {
            self2.callMethod(context, "reset");
            self2.callMethod(context, "update", arg0);
            IRubyObject value2 = self2.callMethod(context, "finish");
            self2.callMethod(context, "reset");
            return value2;
        }

        @JRubyMethod(name={"digest!"})
        public static IRubyObject digest_bang(ThreadContext context, IRubyObject self2) {
            IRubyObject value2 = self2.callMethod(context, "finish");
            self2.callMethod(context, "reset");
            return value2;
        }

        @JRubyMethod
        public static IRubyObject hexdigest(ThreadContext context, IRubyObject self2) {
            return RubyDigest.toHexString(context, DigestInstance.digest(context, self2).convertToString().getBytes());
        }

        @JRubyMethod
        public static IRubyObject hexdigest(ThreadContext context, IRubyObject self2, IRubyObject arg0) {
            return RubyDigest.toHexString(context, DigestInstance.digest(context, self2, arg0).convertToString().getBytes());
        }

        @JRubyMethod(name={"hexdigest!"})
        public static IRubyObject hexdigest_bang(ThreadContext context, IRubyObject self2) {
            return RubyDigest.toHexString(context, DigestInstance.digest_bang(context, self2).convertToString().getBytes());
        }

        @JRubyMethod(name={"bubblebabble"}, meta=true)
        public static IRubyObject bubblebabble(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
            byte[] digest2 = RubyDigest.sites((ThreadContext)context).digest.call(context, recv2, recv2, arg0).convertToString().getBytes();
            return Create.newString(context, BubbleBabble.bubblebabble(digest2, 0, digest2.length));
        }

        @JRubyMethod(name={"bubblebabble"}, meta=true)
        public static IRubyObject bubblebabble(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
            byte[] digest2 = RubyDigest.sites((ThreadContext)context).digest.call(context, recv2, recv2, arg0, arg1).convertToString().getBytes();
            return Create.newString(context, BubbleBabble.bubblebabble(digest2, 0, digest2.length));
        }

        @JRubyMethod
        public static IRubyObject to_s(ThreadContext context, IRubyObject self2) {
            return RubyDigest.sites((ThreadContext)context).hexdigest.call(context, self2, self2);
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject length(ThreadContext context, IRubyObject self2) {
            return RubyDigest.sites((ThreadContext)context).digest_length.call(context, self2, self2);
        }

        @Deprecated
        public static IRubyObject digest(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            return switch (args2.length) {
                case 0 -> DigestInstance.digest(context, self2);
                case 1 -> DigestInstance.digest(context, self2, args2[0]);
                default -> throw Error.argumentError(context, args2.length, 0, 1);
            };
        }

        @Deprecated
        public static IRubyObject hexdigest(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            return RubyDigest.toHexString(context, DigestInstance.digest(context, self2, args2).convertToString().getBytes());
        }

        @Deprecated
        public static IRubyObject bubblebabble(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
            return switch (args2.length) {
                case 1 -> DigestInstance.bubblebabble(context, recv2, args2[0]);
                case 2 -> DigestInstance.bubblebabble(context, recv2, args2[0], args2[1]);
                default -> throw Error.argumentError(context, args2.length, 1, 2);
            };
        }
    }

    @JRubyClass(name={"Digest::Class"})
    public static class DigestClass
    extends RubyObject {
        public DigestClass(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        @JRubyMethod(name={"digest"}, required=1, rest=true, checkArity=false, meta=true)
        public static IRubyObject s_digest(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
            switch (args2.length) {
                case 0: {
                    return DigestClass.s_digest(context, recv2);
                }
                case 1: {
                    return DigestClass.s_digest(context, recv2, args2[0]);
                }
                case 2: {
                    return DigestClass.s_digest(context, recv2, args2[0], args2[1]);
                }
                case 3: {
                    return DigestClass.s_digest(context, recv2, args2[0], args2[1], args2[2]);
                }
            }
            RubyString str = args2[0].convertToString();
            args2 = ArraySupport.newCopy(args2, 1, args2.length - 1);
            IRubyObject obj = ((RubyClass)recv2).newInstance(context, args2, Block.NULL_BLOCK);
            return RubyDigest.sites((ThreadContext)context).digest.call(context, obj, obj, (IRubyObject)str);
        }

        @JRubyMethod(name={"digest"}, checkArity=false, meta=true)
        public static IRubyObject s_digest(ThreadContext context, IRubyObject recv2) {
            throw Error.argumentError(context, "no data given");
        }

        @JRubyMethod(name={"digest"}, checkArity=false, meta=true)
        public static IRubyObject s_digest(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
            RubyString str = arg0.convertToString();
            IRubyObject obj = ((RubyClass)recv2).newInstance(context, Block.NULL_BLOCK);
            return RubyDigest.sites((ThreadContext)context).digest.call(context, obj, obj, (IRubyObject)str);
        }

        @JRubyMethod(name={"digest"}, checkArity=false, meta=true)
        public static IRubyObject s_digest(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
            RubyString str = arg0.convertToString();
            IRubyObject obj = ((RubyClass)recv2).newInstance(context, arg1, Block.NULL_BLOCK);
            return RubyDigest.sites((ThreadContext)context).digest.call(context, obj, obj, (IRubyObject)str);
        }

        @JRubyMethod(name={"digest"}, checkArity=false, meta=true)
        public static IRubyObject s_digest(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            RubyString str = arg0.convertToString();
            IRubyObject obj = ((RubyClass)recv2).newInstance(context, arg1, arg2, Block.NULL_BLOCK);
            return RubyDigest.sites((ThreadContext)context).digest.call(context, obj, obj, (IRubyObject)str);
        }

        @JRubyMethod(name={"hexdigest"}, required=1, optional=1, checkArity=false, meta=true)
        public static IRubyObject s_hexdigest(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
            byte[] digest2 = recv2.callMethod(context, "digest", args2, Block.NULL_BLOCK).convertToString().getBytes();
            return RubyDigest.toHexString(context, digest2);
        }

        @JRubyMethod(name={"hexdigest"}, meta=true)
        public static IRubyObject s_hexdigest(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
            byte[] digest2 = RubyDigest.sites((ThreadContext)context).digest.call(context, recv2, recv2, arg0).convertToString().getBytes();
            return RubyDigest.toHexString(context, digest2);
        }

        @JRubyMethod(name={"hexdigest"}, meta=true)
        public static IRubyObject s_hexdigest(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
            byte[] digest2 = RubyDigest.sites((ThreadContext)context).digest.call(context, recv2, recv2, arg0, arg1).convertToString().getBytes();
            return RubyDigest.toHexString(context, digest2);
        }

        @JRubyMethod(name={"bubblebabble"}, meta=true)
        public static RubyString bubblebabble(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            byte[] digest2 = RubyDigest.sites((ThreadContext)context).digest.call(context, recv2, recv2, arg2).convertToString().getBytes();
            return Create.newString(context, BubbleBabble.bubblebabble(digest2, 0, digest2.length));
        }

        @Deprecated
        public static RubyString bubblebabble(IRubyObject recv2, IRubyObject arg2) {
            return DigestClass.bubblebabble(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg2);
        }

        @Deprecated
        public static IRubyObject s_hexdigest(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
            return DigestClass.s_hexdigest(context, recv2, args2);
        }
    }

    @JRubyClass(name={"Digest::Base"})
    public static class DigestBase
    extends RubyObject {
        private MessageDigest algo;
        private int blockLength = 0;

        public DigestBase(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
            ThreadContext context = runtime2.getCurrentContext();
            if (type2 == Access.getModule(context, "Digest").getClass(context, "Base")) {
                throw runtime2.newNotImplementedError("Digest::Base is an abstract class");
            }
            Metadata metadata = this.getMetadata(type2);
            if (metadata == null) {
                throw runtime2.newNotImplementedError("the " + String.valueOf(type2) + "() function is unimplemented on this machine");
            }
            try {
                this.setAlgorithm(metadata);
            }
            catch (NoSuchAlgorithmException e) {
                throw runtime2.newNotImplementedError("the " + String.valueOf(type2) + "() function is unimplemented on this machine");
            }
        }

        private Metadata getMetadata(RubyModule type2) {
            for (RubyModule current2 = type2; current2 != null; current2 = current2.getSuperClass()) {
                Metadata metadata = (Metadata)current2.getInternalVariable("metadata");
                if (metadata == null) continue;
                return metadata;
            }
            return null;
        }

        @Override
        @JRubyMethod(visibility=Visibility.PRIVATE)
        public IRubyObject initialize_copy(ThreadContext context, IRubyObject obj) {
            if (this == obj) {
                return this;
            }
            DigestBase from = (DigestBase)obj;
            from.checkFrozen();
            try {
                this.algo = (MessageDigest)from.algo.clone();
            }
            catch (CloneNotSupportedException e) {
                String name2 = from.algo.getAlgorithm();
                throw Error.typeError(context, "Could not initialize copy of digest (" + name2 + ")");
            }
            return this;
        }

        @JRubyMethod(name={"update", "<<"})
        public IRubyObject update(IRubyObject obj) {
            ByteList bytes2 = obj.convertToString().getByteList();
            this.algo.update(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize());
            return this;
        }

        @Deprecated(since="10.0")
        public IRubyObject finish() {
            return this.finish(this.getCurrentContext());
        }

        @JRubyMethod
        public IRubyObject finish(ThreadContext context) {
            RubyString digest2 = RubyString.newStringNoCopy(context.runtime, this.algo.digest());
            this.algo.reset();
            return digest2;
        }

        @Deprecated(since="10.0")
        public IRubyObject digest_length() {
            return this.digest_length(this.getCurrentContext());
        }

        @JRubyMethod
        public IRubyObject digest_length(ThreadContext context) {
            return Convert.asFixnum(context, this.algo.getDigestLength());
        }

        @Deprecated(since="10.0")
        public IRubyObject block_length() {
            return this.block_length(this.getCurrentContext());
        }

        @JRubyMethod
        public IRubyObject block_length(ThreadContext context) {
            if (this.blockLength == 0) {
                throw Error.runtimeError(context, String.valueOf(this.getMetaClass()) + " doesn't implement block_length()");
            }
            return Convert.asFixnum(context, this.blockLength);
        }

        @JRubyMethod
        public IRubyObject reset() {
            this.algo.reset();
            return this;
        }

        @JRubyMethod
        public IRubyObject bubblebabble(ThreadContext context) {
            byte[] digest2 = this.algo.digest();
            return Create.newString(context, BubbleBabble.bubblebabble(digest2, 0, digest2.length));
        }

        private void setAlgorithm(Metadata metadata) throws NoSuchAlgorithmException {
            this.algo = RubyDigest.createMessageDigest(metadata.name());
            this.blockLength = metadata.blockLength();
        }
    }

    private record Metadata(String name, int blockLength) {
    }

    @JRubyClass(name={"Digest::SHA512"}, parent="Digest::Base")
    public static class SHA512 {
    }

    @JRubyClass(name={"Digest::SHA384"}, parent="Digest::Base")
    public static class SHA384 {
    }

    @JRubyClass(name={"Digest::SHA256"}, parent="Digest::Base")
    public static class SHA256 {
    }

    @JRubyClass(name={"Digest::SHA1"}, parent="Digest::Base")
    public static class SHA1 {
    }

    @JRubyClass(name={"Digest::RMD160"}, parent="Digest::Base")
    public static class RMD160 {
    }

    @JRubyClass(name={"Digest::MD5"}, parent="Digest::Base")
    public static class MD5 {
    }
}

