/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnainchi;

import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBond;
import io.github.dan2097.jnainchi.InchiBondType;
import io.github.dan2097.jnainchi.InchiInput;
import io.github.dan2097.jnainchi.InchiOptions;
import io.github.dan2097.jnainchi.InchiOutput;
import io.github.dan2097.jnainchi.InchiStereo;
import io.github.dan2097.jnainchi.InchiStereoParity;
import io.github.dan2097.jnainchi.JnaInchi;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

public class SmilesToInchi {
    public static InchiOutput toInchi(String smiles) throws IOException {
        return SmilesToInchi.toInchi(smiles, InchiOptions.DEFAULT_OPTIONS);
    }

    public static InchiOutput toInchi(String smiles, InchiOptions options) throws IOException {
        if (smiles == null) {
            throw new IllegalArgumentException("SMILES should not be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options must not be null");
        }
        Graph g = Graph.fromSmiles(smiles);
        InchiInput input = SmilesToInchi.graphToInput(g);
        return JnaInchi.toInchi(input, options);
    }

    private static InchiInput graphToInput(Graph g) throws IOException {
        int i;
        g = g.kekule();
        InchiInput input = new InchiInput();
        int len = g.order();
        for (i = 0; i < len; ++i) {
            Atom smiAtom = g.atom(i);
            String elementSymbol = smiAtom.element().symbol();
            if ("*".equals(elementSymbol)) {
                elementSymbol = "Zz";
            }
            InchiAtom a = new InchiAtom(elementSymbol);
            a.setCharge(smiAtom.charge());
            a.setImplicitHydrogen(g.implHCount(i));
            if (smiAtom.isotope() != -1) {
                a.setIsotopicMass(smiAtom.isotope());
            }
            input.addAtom(a);
        }
        len = g.order();
        block13: for (i = 0; i < len; ++i) {
            InchiAtom a = input.getAtom(i);
            Configuration stereoConfig = g.configurationOf(i);
            switch (stereoConfig.type()) {
                case Tetrahedral: {
                    int j;
                    int[] neighbours = g.neighbors(i);
                    int implicitHydrogen = g.implHCount(i);
                    InchiAtom[] atoms = new InchiAtom[4];
                    if (neighbours.length == 3 && implicitHydrogen <= 1) {
                        neighbours = Arrays.copyOf(neighbours, 4);
                        neighbours[3] = i;
                        Arrays.sort(neighbours);
                        for (j = 0; j < 4; ++j) {
                            int idx = neighbours[j];
                            atoms[j] = idx == i && implicitHydrogen == 1 ? InchiStereo.STEREO_IMPLICIT_H : input.getAtom(idx);
                        }
                    } else {
                        if (neighbours.length != 4 || implicitHydrogen != 0) continue block13;
                        for (j = 0; j < 4; ++j) {
                            atoms[j] = input.getAtom(neighbours[j]);
                        }
                    }
                    InchiStereoParity parity = stereoConfig == Configuration.TH1 ? InchiStereoParity.ODD : InchiStereoParity.EVEN;
                    input.addStereo(InchiStereo.createTetrahedralStereo(a, atoms[0], atoms[1], atoms[2], atoms[3], parity));
                    continue block13;
                }
                case ExtendedTetrahedral: {
                    SmilesToInchi.addAllenalStereo(input, g, i);
                    continue block13;
                }
                case DoubleBond: 
                case Octahedral: 
                case SquarePlanar: 
                case TrigonalBipyramidal: 
                case Implicit: 
                case None: {
                    continue block13;
                }
            }
        }
        for (Edge smiBond : g.edges()) {
            InchiBondType type;
            int start = smiBond.either();
            int end = smiBond.other(start);
            switch (smiBond.bond()) {
                case AROMATIC: {
                    type = InchiBondType.ALTERN;
                    break;
                }
                case DOT: {
                    type = InchiBondType.NONE;
                    break;
                }
                case DOUBLE: 
                case DOUBLE_AROMATIC: {
                    type = InchiBondType.DOUBLE;
                    break;
                }
                case DOWN: 
                case UP: 
                case IMPLICIT: 
                case IMPLICIT_AROMATIC: 
                case SINGLE: {
                    type = InchiBondType.SINGLE;
                    break;
                }
                case TRIPLE: 
                case QUADRUPLE: {
                    type = InchiBondType.TRIPLE;
                }
                default: {
                    type = InchiBondType.SINGLE;
                }
            }
            InchiBond b = new InchiBond(input.getAtom(start), input.getAtom(end), type);
            input.addBond(b);
            if (smiBond.bond().order() != 2 || SmilesToInchi.findDoublebondStereo(g, input, start, end)) continue;
            SmilesToInchi.findCumuleneStereo(g, input, start, end);
        }
        return input;
    }

    private static boolean findDoublebondStereo(Graph g, InchiInput input, int start, int end) {
        Edge dirEdge1 = SmilesToInchi.findDirectionalEdge(g, start);
        if (dirEdge1 == null) {
            return false;
        }
        Edge dirEdge2 = SmilesToInchi.findDirectionalEdge(g, end);
        if (dirEdge2 == null) {
            return false;
        }
        InchiStereoParity parity = dirEdge1.bond(start) == dirEdge2.bond(end) ? InchiStereoParity.ODD : InchiStereoParity.EVEN;
        InchiAtom atom1 = input.getAtom(dirEdge1.other(start));
        InchiAtom atom2 = input.getAtom(start);
        InchiAtom atom3 = input.getAtom(end);
        InchiAtom atom4 = input.getAtom(dirEdge2.other(end));
        input.addStereo(InchiStereo.createDoubleBondStereo(atom1, atom2, atom3, atom4, parity));
        return true;
    }

    private static boolean findCumuleneStereo(Graph g, InchiInput input, int start, int end) {
        int nextDb1 = SmilesToInchi.nextDb(g, start, end);
        if (nextDb1 < 0) {
            return false;
        }
        int nextDb2 = SmilesToInchi.nextDb(g, end, start);
        if (nextDb2 < 0) {
            return false;
        }
        Edge dirEdge1 = SmilesToInchi.findDirectionalEdge(g, nextDb1);
        if (dirEdge1 == null) {
            return false;
        }
        Edge dirEdge2 = SmilesToInchi.findDirectionalEdge(g, nextDb2);
        if (dirEdge2 == null) {
            return false;
        }
        InchiStereoParity parity = dirEdge1.bond(nextDb1) == dirEdge2.bond(nextDb2) ? InchiStereoParity.ODD : InchiStereoParity.EVEN;
        InchiAtom atom1 = input.getAtom(dirEdge1.other(nextDb1));
        InchiAtom atom2 = input.getAtom(start);
        InchiAtom atom3 = input.getAtom(end);
        InchiAtom atom4 = input.getAtom(dirEdge2.other(nextDb2));
        input.addStereo(InchiStereo.createDoubleBondStereo(atom1, atom2, atom3, atom4, parity));
        return true;
    }

    private static Edge findDirectionalEdge(Graph g, int atom) {
        List<Edge> edges = g.edges(atom);
        if (edges.size() > 1) {
            for (Edge e : edges) {
                Bond b = e.bond();
                if (b != Bond.UP && b != Bond.DOWN) continue;
                return e;
            }
        }
        return null;
    }

    private static void addAllenalStereo(InchiInput input, Graph g, int allenalCenter) {
        int tmp2;
        int tmp1;
        List<Edge> bonds = g.edges(allenalCenter);
        if (bonds.size() != 2 || bonds.get(0).bond().order() != 2 || bonds.get(1).bond().order() != 2) {
            return;
        }
        int doubleBondsInCumulene = 2;
        int next1 = bonds.get(0).other(allenalCenter);
        int next2 = bonds.get(1).other(allenalCenter);
        int prev1 = allenalCenter;
        int prev2 = allenalCenter;
        while ((tmp1 = SmilesToInchi.nextDb(g, next1, prev1)) >= 0 && (tmp2 = SmilesToInchi.nextDb(g, next2, prev2)) >= 0) {
            prev1 = next1;
            prev2 = next2;
            next1 = tmp1;
            next2 = tmp2;
            doubleBondsInCumulene += 2;
        }
        if (doubleBondsInCumulene > 2) {
            return;
        }
        int[] atomIdxs = new int[4];
        int pos = 0;
        for (Edge edge : g.edges(next1)) {
            if (edge.bond().order() == 2) continue;
            atomIdxs[pos++] = edge.other(next1);
        }
        int implHyd1 = g.implHCount(next1);
        if (implHyd1 > 0) {
            if (implHyd1 > 1) {
                return;
            }
            atomIdxs[pos++] = next1;
        }
        if (pos != 2) {
            return;
        }
        for (Edge e : g.edges(next2)) {
            if (e.bond().order() == 2) continue;
            atomIdxs[pos++] = e.other(next2);
        }
        int n = g.implHCount(next2);
        if (n > 0) {
            if (n > 1) {
                return;
            }
            atomIdxs[pos++] = next2;
        }
        if (pos != 4) {
            return;
        }
        Arrays.sort(atomIdxs);
        InchiAtom[] atoms = new InchiAtom[4];
        for (int i = 0; i < atomIdxs.length; ++i) {
            int idx = atomIdxs[i];
            atoms[i] = idx == next1 || idx == next2 ? InchiStereo.STEREO_IMPLICIT_H : input.getAtom(idx);
        }
        InchiStereoParity parity = g.configurationOf(allenalCenter) == Configuration.AL1 ? InchiStereoParity.ODD : InchiStereoParity.EVEN;
        input.addStereo(InchiStereo.createAllenalStereo(input.getAtom(allenalCenter), atoms[0], atoms[1], atoms[2], atoms[3], parity));
    }

    private static int nextDb(Graph g, int current, int prev) {
        List<Edge> bonds = g.edges(current);
        if (bonds.size() != 2 || bonds.get(0).bond().order() != 2 || bonds.get(1).bond().order() != 2) {
            return -1;
        }
        for (Edge e : bonds) {
            int next = e.other(current);
            if (next == prev) continue;
            return next;
        }
        return -1;
    }
}

